/*******************************************************************************
 * Copyright (c) 2014 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.chart.property;

import org.simantics.browsing.ui.swt.widgets.impl.ReadFactoryImpl;
import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.utils.datastructures.Triple;

/**
 * @author Tuukka Lehtonen
 */
public class BooleanPropertyFactory extends ReadFactoryImpl<Resource, Boolean> {

    final private String propertyURI;

    public BooleanPropertyFactory(String propertyURI) {
        this.propertyURI = propertyURI;
    }

    @Override
    public Object getIdentity(Object inputContents) {
        return new Triple<Resource, String, Object>((Resource) inputContents, propertyURI, getClass());
    }

    @Override
    public Boolean perform(ReadGraph graph, Resource r) throws DatabaseException {
        return Boolean.TRUE.equals( graph.getPossibleRelatedValue2(r, graph.getResource(propertyURI), Bindings.BOOLEAN) );
    }

}
