/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.simantics.DatabaseJob;
import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.modeling.NewComponentType;
import org.simantics.modeling.ui.Activator;
import org.simantics.modeling.ui.commandlog.NewComponentTypeCommand;
import org.simantics.utils.commandlog.Commands;

public class NewComponentTypeAction implements ActionFactory {

    @Override
    public Runnable create(Object target) {
        if(!(target instanceof Resource))
            return null;
        final Resource library = (Resource) target;
        return new Runnable() {
            @Override
            public void run() {
                Job job = new DatabaseJob(Messages.NewComponentTypeAction_NewUserComponent) {
                    @Override
                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            Simantics.getSession().syncRequest(new WriteRequest() {
                                @Override
                                public void perform(WriteGraph graph) throws DatabaseException {
                                    graph.markUndoPoint();
                                    Resource componentType = NewComponentType.createComponentType(graph, library);
                                    if(Commands.isRecording())
                                        Commands.record(graph, new NewComponentTypeCommand(componentType, library));
                                }
                            });
                            return Status.OK_STATUS;
                        } catch (DatabaseException e) {
                            return new Status(IStatus.ERROR, Activator.PLUGIN_ID, Messages.NewComponentTypeAction_ActivatorFailedToCreateNewUserComponent, e); 
                        }
                    }
                };
                job.schedule();
            }
        };
    }

}
