/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.actions;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.db.ReadGraph;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.ui.contribution.DynamicMenuContribution;
import org.simantics.utils.ui.BundleUtils;


/**
 * @author Antti Villberg
 */
abstract public class ExplorerDynamicMenuContribution<T> extends DynamicMenuContribution {

	private static final IContributionItem[] NONE = {};

	@Override
	protected IContributionItem[] getContributionItems(ReadGraph graph, Object[] selection) throws DatabaseException {

		T input = computeInput(graph, selection);

		if(input == null) return NONE;

		return new IContributionItem[] {
				new ActionContributionItem(new Helper(graph, input))
		};

	}

	public class Helper extends Action {

		private final T input;
		protected final Session        session;

		public Helper(ReadGraph graph, T input) throws DatabaseException {
			super(getName(graph, input), getImage(graph, input));
			this.session = graph.getSession();
			this.input = input;
		}

		@Override
		public void run() {
			perform(session, input);
		}

	}

	protected ImageDescriptor silk(String name) {
		return BundleUtils.getImageDescriptorFromBundle(Platform.getBundle("com.famfamfam.silk"), "/icons/" + name); //$NON-NLS-1$ //$NON-NLS-2$
	}

	abstract protected T computeInput(ReadGraph graph, Object[] selection) throws DatabaseException;
	abstract protected void perform(Session session, T input);
	abstract protected String getName(ReadGraph graph, T input) throws DatabaseException ;
	abstract protected ImageDescriptor getImage(ReadGraph graph, T input) throws DatabaseException;

}
