/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.actions;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.services.IServiceScopes;
import org.simantics.browsing.ui.platform.PropertyPageView;
import org.simantics.utils.ui.ExceptionUtils;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

/**
 * @author Tuukka Lehtonen
 */
public class DuplicatePinnedViewHandler extends AbstractHandler {

    private static final String PIN_SELECTION_COMMAND = "org.simantics.modeling.ui.pinSelection"; //$NON-NLS-1$

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchPart originalPart = HandlerUtil.getActivePartChecked(event);
        if (!(originalPart instanceof PropertyPageView))
            return null;
        PropertyPageView originalPropertyView = (PropertyPageView) originalPart;

        try {
            // Activate a new unique instance of the same property page view.
            // Its initialization procedures and IContributedContentsView
            // implementation should take care that the view will be initialized
            // with a property page just like the original.
            ISelection originalSelection = originalPropertyView.getLastSelection();

            final String id = originalPart.getSite().getId() + "Pinned:" + UUID.randomUUID().toString(); //$NON-NLS-1$
            PropertyPageView newPart = (PropertyPageView) WorkbenchUtils.activateView(id);

            newPart.partActivated(originalPart);
            newPart.selectionChanged(originalPart, originalSelection);

            // Make sure that the view is pinned and that its pinned button is in the right state.
            newPart.pinWorkbenchSelection(true);

            ICommandService commandService = (ICommandService) newPart.getViewSite().getService(ICommandService.class);
            Map<Object, Object> filter = new HashMap<Object, Object>();
            filter.put(IServiceScopes.PARTSITE_SCOPE, newPart.getSite());
            commandService.refreshElements(PIN_SELECTION_COMMAND, filter);

        } catch (Exception e) {
            ExceptionUtils.logAndShowError(e);
        }

        return null;
    }

}
