package org.simantics.modeling.ui.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

import org.simantics.Simantics;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.Logger;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.db.layer0.adapter.ActionFactory2;
import org.simantics.db.layer0.util.RemoverUtil;

public class Delete implements ActionFactory, ActionFactory2 {

	@Override
    public Runnable create(Object target) {
		return create(Collections.singletonList(target));
	}

	@Override
    public Runnable create(Collection<?> target) {

		final ArrayList<Resource> resources = new ArrayList<Resource>();
		
		for(Object o : target) {
			if(!(o instanceof Resource))
				return null;
			resources.add((Resource)o);
		}
        
        return new Runnable() {
            @Override
            public void run() {

            	for(Resource r : resources) {
            		try {
						Simantics.getSession().syncRequest(new WriteRequest() {

							@Override
							public void perform(WriteGraph graph) throws DatabaseException {
								RemoverUtil.remove(graph, r);
							}

						});
					} catch (DatabaseException e) {
						Logger.defaultLogError(e);
					}
            	}
            	
            }
        };
    }

}
