/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui;

import java.util.Hashtable;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.simantics.Simantics;
import org.simantics.modeling.ui.scl.imports.OntologyImportModulesAction;
import org.simantics.modeling.ui.scl.imports.SCLModulesImportModulesAction;
import org.simantics.scl.compiler.commands.SCLConsoleListener;
import org.simantics.scl.ui.imports.ImportModulesAction;
import org.simantics.utils.FileUtils;
import org.simantics.utils.ui.BundleUtils;

public class Activator extends AbstractUIPlugin {

    public static final String PLUGIN_ID = "org.simantics.modeling.ui"; //$NON-NLS-1$

    // The shared instance
    private static Activator plugin;
    private static BundleContext context;

    public static String          DOCUMENT_SVG_TEXT;
    public static String          FATAL_SVG_TEXT;
    public static String          ERROR_SVG_TEXT;
    public static String          WARNING_SVG_TEXT;
    public static String          INFO_SVG_TEXT;
    public static String          NOTE_SVG_TEXT;
    
    public static ImageDescriptor CHANGED_DECORATOR_ICON;

    public static ImageDescriptor BULLET_GREEN_ICON;
    public static ImageDescriptor BULLET_YELLOW_ICON;

    public static ImageDescriptor MODEL_ICON;
    public static ImageDescriptor COMPONENT_ICON;
    public static ImageDescriptor COMPONENT_TYPE_ICON;
    public static ImageDescriptor COMPOSITE_ICON;
    public static ImageDescriptor INTERFACE_ICON;
    public static ImageDescriptor VARIABLE_ICON;
    public static ImageDescriptor CONNECTION_ICON;
    public static ImageDescriptor CONNECTION_PROPERTY_ICON;
    public static ImageDescriptor OPEN_CONNECTION_ICON;
    public static ImageDescriptor ARROW_LEFT_ICON;
    public static ImageDescriptor ARROW_RIGHT_ICON;
    public static ImageDescriptor SYMBOL_ICON;
    public static ImageDescriptor EXPERIMENTS_ICON;
    public static ImageDescriptor STATES_ICON;
    public static ImageDescriptor QUERY_ICON;
    public static ImageDescriptor EXPERIMENT_ICON;
    public static ImageDescriptor EXPERIMENT_RESULT_ICON;
    public static ImageDescriptor EXPERIMENT_RESULT_TRANSIENT_ICON;
    public static ImageDescriptor ATTACHED_EXPERIMENT_ICON;
    public static ImageDescriptor STATE_ICON;
    public static ImageDescriptor TRENDS_ICON;
    public static ImageDescriptor TREND_ICON;
    public static ImageDescriptor CHARTGROUP_ICON;
    public static ImageDescriptor CHART_ICON;
    public static ImageDescriptor CHARTS_ICON;
    public static ImageDescriptor SPREADSHEET_ICON;
    public static ImageDescriptor SPREADSHEETS_ICON;
    public static ImageDescriptor SUBSCRIPTION_ICON;
    public static ImageDescriptor SUBSCRIPTION_DISABLED_ICON;
    public static ImageDescriptor SUBSCRIPTION_ITEM_ICON;
    public static ImageDescriptor SUBSCRIPTIONS_ICON;
    public static ImageDescriptor IMAGE_ICON;
    public static ImageDescriptor IMAGES_ICON;
    public static ImageDescriptor PLOT_ICON;
    public static ImageDescriptor SEGMENT_ICON;

    public static ImageDescriptor TICK_ICON;
    public static ImageDescriptor CROSS_ICON;
    public static ImageDescriptor STOP_ICON;
    public static ImageDescriptor ARROW_IN_ICON;
    public static ImageDescriptor ARROW_UP_ICON;
    public static ImageDescriptor ARROW_DOWN_ICON;
    public static ImageDescriptor SHOW_PROFILE_MONITOR_ICON;
    public static ImageDescriptor HIDE_PROFILE_MONITOR_ICON;

    public static ImageDescriptor POINTER_MODE;
    public static ImageDescriptor CONNECT_MODE;

    public static ImageDescriptor ARROW_REFRESH;

    @Override
    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        Activator.context = context;

        Bundle bundle = context.getBundle();

        DOCUMENT_SVG_TEXT = FileUtils.getContents(bundle.getResource("icons/Gnome-mime-document.svg")); //$NON-NLS-1$
        FATAL_SVG_TEXT = FileUtils.getContents(bundle.getResource("icons/fatal.svg")); //$NON-NLS-1$
        ERROR_SVG_TEXT = FileUtils.getContents(bundle.getResource("icons/error.svg")); //$NON-NLS-1$
        WARNING_SVG_TEXT = FileUtils.getContents(bundle.getResource("icons/warning.svg")); //$NON-NLS-1$
        INFO_SVG_TEXT = FileUtils.getContents(bundle.getResource("icons/info.svg")); //$NON-NLS-1$
        NOTE_SVG_TEXT = FileUtils.getContents(bundle.getResource("icons/note4.svg")); //$NON-NLS-1$

        CHANGED_DECORATOR_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/changed_decorator.png")); //$NON-NLS-1$

        BULLET_GREEN_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/bullet_green.png")); //$NON-NLS-1$
        BULLET_YELLOW_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/bullet_yellow.png")); //$NON-NLS-1$

        MODEL_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/chart_organisation.png")); //$NON-NLS-1$
        COMPONENT_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/brick.png")); //$NON-NLS-1$
        COMPONENT_TYPE_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/box.png")); //$NON-NLS-1$
        COMPOSITE_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/bricks.png")); //$NON-NLS-1$
        INTERFACE_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/application_view_list.png")); //$NON-NLS-1$
        CONNECTION_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/connection.png")); //$NON-NLS-1$
        CONNECTION_PROPERTY_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/table_relationship.png")); //$NON-NLS-1$
        OPEN_CONNECTION_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/open_connection.png")); //$NON-NLS-1$
        VARIABLE_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/variable.png")); //$NON-NLS-1$

        ARROW_LEFT_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/arrow_left.png")); //$NON-NLS-1$
        ARROW_RIGHT_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/arrow_right.png")); //$NON-NLS-1$

        SYMBOL_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/photo.png")); //$NON-NLS-1$

        EXPERIMENTS_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/folder.png")); //$NON-NLS-1$
        ATTACHED_EXPERIMENT_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/time_attach.png")); //$NON-NLS-1$
        EXPERIMENT_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/time.png")); //$NON-NLS-1$
        EXPERIMENT_RESULT_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/chart_bar.png")); //$NON-NLS-1$
        EXPERIMENT_RESULT_TRANSIENT_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/chart_bar_light.png")); //$NON-NLS-1$

        QUERY_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/report.png")); //$NON-NLS-1$

        STATES_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/folder_tag_red.png")); //$NON-NLS-1$
        STATE_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/tag_red.png")); //$NON-NLS-1$

        TRENDS_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/folder.png")); //$NON-NLS-1$
        TREND_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/chart_line.png")); //$NON-NLS-1$

        CHARTGROUP_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/chart_group2.png")); //$NON-NLS-1$
        CHARTS_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/folder.png")); //$NON-NLS-1$
        CHART_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/chart_line.png")); //$NON-NLS-1$
        PLOT_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/tag_blue.png")); //$NON-NLS-1$

        SPREADSHEET_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/table.png")); //$NON-NLS-1$
        SPREADSHEETS_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/folder_table.png")); //$NON-NLS-1$

        SUBSCRIPTION_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/subscription.png")); //$NON-NLS-1$
        SUBSCRIPTION_DISABLED_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/subscription_disabled.png")); //$NON-NLS-1$
        SUBSCRIPTIONS_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/subscriptions.png")); //$NON-NLS-1$
        SUBSCRIPTION_ITEM_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/tag_blue.png")); //$NON-NLS-1$

        IMAGE_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/image.png")); //$NON-NLS-1$
        IMAGES_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/images.png")); //$NON-NLS-1$

        SEGMENT_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/segment_edit.gif")); //$NON-NLS-1$

        TICK_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/tick.png")); //$NON-NLS-1$
        CROSS_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/silk/cross.png")); //$NON-NLS-1$
        STOP_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/stop_red.png")); //$NON-NLS-1$
        ARROW_IN_ICON = BundleUtils.getImageDescriptorFromPlugin("com.famfamfam.silk", "icons/arrow_in.png"); //$NON-NLS-1$ //$NON-NLS-2$
        ARROW_UP_ICON = BundleUtils.getImageDescriptorFromPlugin("com.famfamfam.silk", "icons/bullet_arrow_up.png"); //$NON-NLS-1$ //$NON-NLS-2$
        ARROW_DOWN_ICON = BundleUtils.getImageDescriptorFromPlugin("com.famfamfam.silk", "icons/bullet_arrow_down.png"); //$NON-NLS-1$ //$NON-NLS-2$
        SHOW_PROFILE_MONITOR_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/show-profile-monitors.png")); //$NON-NLS-1$
        HIDE_PROFILE_MONITOR_ICON = ImageDescriptor.createFromURL(bundle.getResource("icons/hide-profile-monitors.png")); //$NON-NLS-1$

        POINTER_MODE = ImageDescriptor.createFromURL(bundle.getResource("icons/pointertool.png")); //$NON-NLS-1$
        CONNECT_MODE = ImageDescriptor.createFromURL(bundle.getResource("icons/connecttool.png")); //$NON-NLS-1$
        
        ARROW_REFRESH = ImageDescriptor.createFromURL(bundle.getResource("icons/arrow_refresh.png")); //$NON-NLS-1$
        
        Hashtable<String, String> properties = new Hashtable<String, String>();
        context.registerService(SCLConsoleListener.class,
                new SCLConsoleListener() {
                    @Override
                    public void startedExecution() {
                        Simantics.getSession().markUndoPoint();
                    }
                }, properties);
        
        context.registerService(ImportModulesAction.class, OntologyImportModulesAction.INSTANCE,
                properties);
        context.registerService(ImportModulesAction.class, SCLModulesImportModulesAction.INSTANCE,
                properties);
    }

    @Override
    protected void initializeImageRegistry(ImageRegistry reg) {
        reg.put("tick", TICK_ICON); //$NON-NLS-1$
        reg.put("cross", CROSS_ICON); //$NON-NLS-1$
        reg.put("stop", STOP_ICON); //$NON-NLS-1$
        reg.put("arrowIn", ARROW_IN_ICON); //$NON-NLS-1$
        reg.put("arrowUp", ARROW_UP_ICON); //$NON-NLS-1$
        reg.put("arrowDown", ARROW_DOWN_ICON); //$NON-NLS-1$
        reg.put("showProfileMonitors", SHOW_PROFILE_MONITOR_ICON); //$NON-NLS-1$
        reg.put("hideProfileMonitors", HIDE_PROFILE_MONITOR_ICON); //$NON-NLS-1$
        reg.put("arrow_refresh", ARROW_REFRESH); //$NON-NLS-1$
    }

    /*
     * (non-Javadoc)
     * @see org.eclipse.ui.plugin.AbstractUIPlugin#stop(org.osgi.framework.BundleContext)
     */
    @Override
    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    /**
     * Returns the shared instance
     *
     * @return the shared instance
     */
    public static Activator getDefault() {
        return plugin;
    }
    
    public static BundleContext getContext() {
        return context;
    }

}
