package org.simantics.modeling.typicals.rules;

import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.query.DiagramRequests;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.g2d.page.DiagramDesc;
import org.simantics.modeling.typicals.ITypicalSynchronizationRule;
import org.simantics.modeling.typicals.TypicalInfo;

/**
 * @author Tuukka Lehtonen
 * @since 1.22.2, 1.25.0
 */
public enum PageSettingsTypicalRule implements ITypicalSynchronizationRule {

	INSTANCE;

	public static PageSettingsTypicalRule get() {
		return INSTANCE;
	}

	@Override
	public boolean synchronize(WriteGraph graph, Resource template, Resource instance, TypicalInfo info) throws DatabaseException {
		// Diagrams should always have some sort of diagram description.
		// If the template doesn't have one, the existing description
		// from the instance shall not be removed.
		DiagramDesc mdesc = graph.syncRequest(DiagramRequests.getDiagramDesc(template));
		if (mdesc == null) {
			info.messageLog.add("\t\ttemplate doesn't have any diagram page settings, doing nothing");
			return false;
		}
		DiagramDesc idesc = graph.syncRequest(DiagramRequests.getDiagramDesc(instance));
		if (mdesc.equals(idesc))
			return false;

		DiagramGraphUtil.setDiagramDesc(graph, instance, mdesc);
		info.messageLog.add("\t\tset diagram page settings:"
				+ "\n\t\t\tshow page borders: " + mdesc.isPageBordersVisible()
				+ "\n\t\t\tshow margins:      " + mdesc.isMarginsVisible()
				+ "\n\t\t\tgrid size:         " + mdesc.getGridSize()
				+ "\n\t\t\tpage settings:     " + mdesc.getPageDesc()
				+ "\n");
		return true;
	}

}
