/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.typicals;

import java.util.ArrayList;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.NamedResource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.TransferableGraphConfiguration2;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.ModelingUtils.CompositeInfo;
import org.simantics.modeling.ModelingUtils.DiagramComponentInfo;
import org.simantics.modeling.adapters.CompositeCopyHandler;
import org.simantics.structural.stubs.StructuralResource2;

/**
 * @author Tuukka Lehtonen
 */
public class TypicalCompositeCopyHandler extends CompositeCopyHandler {

    public TypicalCompositeCopyHandler(Resource composite) {
    	super(composite);
    }
    
    @Override
    protected TransferableGraphConfiguration2 createConfiguration(ReadGraph graph, boolean cut) throws DatabaseException {
    	
    	Layer0 L0 = Layer0.getInstance(graph);
    	StructuralResource2 SR = StructuralResource2.getInstance(graph);
    	DiagramResource DIA = DiagramResource.getInstance(graph);
    	ModelingResources MOD = ModelingResources.getInstance(graph);

    	Resource resource = getResource();
    	
    	// Process joins
    	ArrayList<Resource> exclusions = new ArrayList<Resource>();
    	for(Resource join : graph.getObjects(resource, SR.HasConnectionJoin)) {
    		// Internals are included
    		if(graph.getPossibleObject(join, SR.JoinsComposite) != null) continue;
    		// Externals are omitted
    		exclusions.add(join);
    	}
    	// Exclude both composite and possible diagram types from copy
    	for (Resource type : graph.getObjects(resource, L0.InstanceOf)) {
    	    if (graph.isInheritedFrom(type, MOD.TypicalComposite)) {
    	        exclusions.add(type);
    	    }
    	}
    	Resource diagram = graph.getPossibleObject(resource, MOD.CompositeToDiagram);
    	if (diagram != null) {
            for (Resource type : graph.getObjects(diagram, L0.InstanceOf)) {
                if (graph.isInheritedFrom(type, DIA.Diagram)) {
                    exclusions.add(type);
                }
            }
    	}

    	ArrayList<NamedResource> roots = new ArrayList<NamedResource>();
    	// Include resource as root
    	CompositeInfo info = CompositeInfo.fromResource(graph, resource);
    	//String rootName = graph.getRelatedValue(resource, L0.HasName, Bindings.STRING);
    	roots.add(new NamedResource(info.getTGName(), resource));
    	// Include components as roots
    	for(Resource child : graph.sync(new ObjectsWithType(resource, L0.ConsistsOf, SR.Component))) {
    		DiagramComponentInfo cinfo = DiagramComponentInfo.fromResource(graph, info, child);
        	roots.add(new NamedResource(cinfo.getTGName(info), child));
    	}
    	
    	TransferableGraphConfiguration2 result = TransferableGraphConfiguration2.createWithNames(graph, roots, exclusions, true, false);
    	return  result;
    	
    }

}
