/*******************************************************************************
 * Copyright (c) 2007, 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.typicals;

import gnu.trove.map.hash.THashMap;

import java.util.TreeSet;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.UnaryRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;

/**
 * Reads a TypicalInfo info structure for the specified typical diagram instance.
 *  
 * @author Tuukka Lehtonen
 */
public class ReadTypicalInfo extends UnaryRead<Resource, TypicalInfoBean> {

    public ReadTypicalInfo(Resource typicalInstance) {
        super(typicalInstance);
    }

    @Override
    public TypicalInfoBean perform(ReadGraph graph) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance(graph);
        DiagramResource DIA = DiagramResource.getInstance(graph);
        ModelingResources MOD = ModelingResources.getInstance(graph);

        TypicalInfoBean info = new TypicalInfoBean();
        info.instanceElements = new TreeSet<Resource>( graph.syncRequest( new ObjectsWithType(parameter, L0.ConsistsOf, DIA.Element) ) );
        info.instanceToTemplate = new THashMap<Resource, Resource>( info.instanceElements.size() );
        info.templateToInstance = new THashMap<Resource, Resource>( info.instanceElements.size() );
        info.isTemplatized = new TreeSet<Resource>();
        for (Resource instanceElement : info.instanceElements) {
            Resource templateElement = graph.getPossibleObject(instanceElement, MOD.HasElementSource);
            if (templateElement != null) {
                info.instanceToTemplate.put(instanceElement, templateElement);
                info.templateToInstance.put(templateElement, instanceElement);
            }
            if (graph.hasStatement(instanceElement, MOD.IsTemplatized))
                info.isTemplatized.add(instanceElement);
        }
        return info;
    }

}