package org.simantics.modeling.scl;

import java.util.Map;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.procedure.adapter.TransientCacheListener;
import org.simantics.db.common.request.IndexRoot;
import org.simantics.db.common.request.ResourceRead2;
import org.simantics.db.common.request.RuntimeEnvironmentRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.layer0.Layer0;
import org.simantics.scl.compiler.common.names.Name;
import org.simantics.scl.compiler.elaboration.expressions.EApply;
import org.simantics.scl.compiler.elaboration.expressions.EConstant;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.modules.SCLValue;
import org.simantics.scl.compiler.environment.Environment;
import org.simantics.scl.compiler.runtime.RuntimeEnvironment;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.structural2.scl.CompileStructuralValueRequest;
import org.simantics.structural2.scl.ComponentTypeProperty;
import org.simantics.structural2.scl.ReadComponentTypeInterfaceRequest;

public class CompileSCLQueryRequest extends CompileStructuralValueRequest {

    public CompileSCLQueryRequest(ReadGraph graph, Variable context)
            throws DatabaseException {
        super(graph, context);
    }

    public static Object compileAndEvaluate(ReadGraph graph, Variable context) throws DatabaseException {
        SCLContext sclContext = SCLContext.getCurrent();
        Object oldGraph = sclContext.get("graph");
        try {
            Function1<Object,Object> exp = graph.syncRequest(new CompileSCLQueryRequest(graph, context),
                    TransientCacheListener.<Function1<Object,Object>>instance());
            sclContext.put("graph", graph);
            return exp.apply(context);
        } catch (DatabaseException e) {
            throw (DatabaseException)e;
        } catch (Throwable t) {
            throw new DatabaseException(t);
        } finally {
            sclContext.put("graph", oldGraph);
        }
    }

    protected static Name INPUT_VARIABLE = Name.create("Simantics/Query", "inputVariable");
    protected static Name SESSION_VARIABLE = Name.create("Simantics/Query", "sessionVariable");
    public static final Type VARIABLE = Types.con("Simantics/Variables", "Variable"); 

    protected static Expression accessQueryVariable(Environment environment,
            org.simantics.scl.compiler.elaboration.expressions.Variable contextVariable) {
        SCLValue variableParentFunction = environment.getValue(VARIABLE_PARENT);
        return new EApply(new EConstant(variableParentFunction), new EVariable(contextVariable));
    }

    @Override
    protected Expression getVariableAccessExpression(
            ReadGraph graph,
            CompilationContext context,
            org.simantics.scl.compiler.elaboration.expressions.Variable contextVariable,
            String name) throws DatabaseException {
        ComponentTypeProperty property = context.propertyMap.get(name);
        if(property != null) {
            Environment environment = context.runtimeEnvironment.getEnvironment();
            return getPropertyFlexible(environment,
            		accessQueryVariable(environment, contextVariable),
                    name,
                    property.type);
        }
        else if(name.equals("input")) {
            Environment environment = context.runtimeEnvironment.getEnvironment();
            return new EApply(
                            new EConstant(environment.getValue(INPUT_VARIABLE)),
                            new EVariable(contextVariable));
        }
        else if(name.equals("session")) {
            Environment environment = context.runtimeEnvironment.getEnvironment();
            return new EApply(
                            new EConstant(environment.getValue(SESSION_VARIABLE)),
                            new EVariable(contextVariable));
        }
        else if(name.equals("self"))
            return new EVariable(contextVariable);
        else
            return null;
    }
    
    @Override
    protected CompilationContext getCompilationContext(ReadGraph graph) throws DatabaseException {
    	Resource indexRoot = graph.syncRequest(new IndexRoot(literal));
        return graph.syncRequest(new ResourceRead2<CompilationContext>(component, indexRoot) {
            @Override
            public CompilationContext perform(ReadGraph graph) throws DatabaseException {
            	Layer0 L0 = Layer0.getInstance(graph);
                Resource type = graph.getPossibleType(component, L0.Entity);
                RuntimeEnvironment runtimeEnvironment = graph.syncRequest(new RuntimeEnvironmentRequest(resource2));
                Map<String, ComponentTypeProperty> propertyMap =
                        graph.syncRequest(new ReadComponentTypeInterfaceRequest(type, runtimeEnvironment.getEnvironment()),
                                TransientCacheListener.<Map<String, ComponentTypeProperty>>instance());
                return new CompilationContext(runtimeEnvironment, propertyMap);
            }
        });
    }
    
}
