package org.simantics.modeling.commandlog;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.utils.commandlog.Commands;

public class CommandRecording {
	public static void recordLinkSharedOntology(ReadGraph graph, Resource target, Resource ontology) {
		if (Commands.isRecording()) {
			Commands.record(graph, new LinkSharedOntologyCommand(target, ontology));
		}
	}
	public static void recordUnlinkSharedOntology(ReadGraph graph, Resource target, Resource ontology) {
		if (Commands.isRecording()) {
			Commands.record(graph, new UnlinkSharedOntologyCommand(target, ontology));
		}		
	}
}
