package org.simantics.modeling.adapters;

import org.simantics.browsing.ui.content.LabelDecorator;
import org.simantics.browsing.ui.model.labeldecorators.AbstractLabelDecorator;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.modeling.ModelingResources;

public class SCLLabelBackgroundColorRule extends SCLLabelColorRule {
    
    public SCLLabelBackgroundColorRule(ReadGraph graph, Resource rule) {
        super(graph, rule, ModelingResources.getInstance(graph).SCLLabelBackgroundColorRule_getColor);
    }

    @Override
    public LabelDecorator getLabelDecorator(ReadGraph graph, Object content) throws DatabaseException {
        return new AbstractLabelDecorator() {

            @Override
            public <Color> Color decorateBackground(Color color, String column, int itemIndex) {
                return decorateColor(graph, content, color, column, itemIndex);
            }
        };
    }
}