/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.adapters;

import java.util.Collection;
import java.util.Map;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.impl.AbstractRemover;
import org.simantics.db.layer0.util.RemoverUtil;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.utils.RemoverUtils;
import org.simantics.modeling.utils.RemoverUtils.ValidationResult;

/**
 * @author Tuukka Lehtonen
 * @see TerminalRemover
 */
public class ConnectionRelationRemover extends AbstractRemover {

    public ConnectionRelationRemover(Resource connectionRelation) {
        super(connectionRelation);
    }

    @Override
    public String canRemove(ReadGraph graph, Map<Object, Object> aux) throws DatabaseException {
        ModelingResources MOD = ModelingResources.getInstance(graph);
        Resource diagramConnectionRelation = null;
        Resource connectionRelation = graph.getPossibleObject(resource, MOD.DiagramConnectionRelationToConnectionRelation);
        if (connectionRelation != null)
            diagramConnectionRelation = resource;
        else
            connectionRelation = resource;
        ValidationResult result = RemoverUtils.validateConnectionRelationRemoval(graph, connectionRelation, diagramConnectionRelation);
        if (result.inUse())
            return RemoverUtils.formatError(graph, result);
        return null;
    }

    @Override
    public void remove(WriteGraph graph) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance(graph);
        DiagramResource DIA = DiagramResource.getInstance(graph);
        ModelingResources MOD = ModelingResources.getInstance(graph);

        Collection<Resource> lifts = graph.getObjects(resource, DIA.Lifts);

        // Not necessary, this is legacy support only.
        for (Resource def : graph.getObjects(resource, L0.ConcernsRelation_Inverse))
            graph.deny(def);

        // Remove possible symbol terminal(s).
        for (Resource diagramConnectionRelation : graph.getObjects(resource, MOD.ConnectionRelationToDiagramConnectionRelation)) {
            removeTerminals(graph, DIA, diagramConnectionRelation);
            Resource diagramConnectionRelationInverse = graph.getPossibleObject(diagramConnectionRelation, L0.InverseOf);
            graph.deny(diagramConnectionRelation);
            if (diagramConnectionRelationInverse != null)
                graph.deny(diagramConnectionRelationInverse);
        }
        removeTerminals(graph, DIA, resource);

        Resource connectionRelationInverse = graph.getPossibleObject(resource, L0.InverseOf);
        graph.deny(resource);
        if (connectionRelationInverse != null)
            graph.deny(connectionRelationInverse);

        if (!lifts.isEmpty())
            for (Resource lift : lifts)
                RemoverUtil.remove(graph, lift);
    }
    
    private void removeTerminals(WriteGraph graph, DiagramResource DIA, Resource diagramConnectionRelation) throws DatabaseException {
        for (Resource terminal : graph.getObjects(diagramConnectionRelation, DIA.HasConnectionPoint_Inverse)) {
            for (Resource ownerList : OrderedSetUtils.getOwnerLists(graph, terminal, DIA.Composite)) {
                OrderedSetUtils.remove(graph, ownerList, terminal);
            }
            RemoverUtil.remove(graph, terminal);
        }
    }

}
