package org.simantics.modeling.adapters;

import java.util.Objects;

import org.simantics.db.Resource;

public class ChangeInformationProperty {

	public static enum ChangeInformationPropertyType {
		CREATEDBY("Author"),CREATEDAT("Created At"),MODIFIEDBY("Last Modified By"),MODIFIEDAT("Last Modified At");
		final public String label;
		ChangeInformationPropertyType(String label) {
			this.label = label;
		}
	}

	public final Resource resource;
	public final ChangeInformationPropertyType type;

	public ChangeInformationProperty(ChangeInformationPropertyType type, Resource resource) {
		assert type != null;
		this.type = type;
		this.resource = resource;
	}

	@Override
	public int hashCode() {
		return 31 * Objects.hashCode(resource) + type.hashCode();
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		ChangeInformationProperty other = (ChangeInformationProperty) obj;
		return Objects.equals(resource, other.resource) && type == other.type;
	}

}
