/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.userComponent;

import gnu.trove.map.hash.THashMap;

import org.simantics.databoard.Datatypes;
import org.simantics.databoard.type.ArrayType;
import org.simantics.databoard.type.Datatype;

public class TypeConversion {

	private static final THashMap<String,Datatype> CONVERSION_MAP = 
			new THashMap<String,Datatype>();
	
	private static void add(String sclType, Datatype dataType) {
		CONVERSION_MAP.put(sclType, dataType);
		CONVERSION_MAP.put("[" + sclType + "]", new ArrayType(dataType));
		CONVERSION_MAP.put("Array " + sclType, new ArrayType(dataType));
		CONVERSION_MAP.put("Vector " + sclType, new ArrayType(dataType));
	}
	
	static {
		add("Boolean", Datatypes.BOOLEAN);
		add("Integer", Datatypes.INTEGER);
		add("Long", Datatypes.LONG);
		add("Float", Datatypes.FLOAT);
		add("Double", Datatypes.DOUBLE);
		add("String", Datatypes.STRING);
	}
	
	/**
	 * This is a workaround solution currently for converting SCL types
	 * to datatypes.
	 */
	public static Datatype convertSCLTypeToDatatype(String type) {
		return CONVERSION_MAP.get(type);
	}
	
}
