/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.typicals.rules;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.typicals.ITypicalSynchronizationRule;
import org.simantics.modeling.typicals.TypicalInfo;
import org.simantics.modeling.typicals.TypicalUtil;
import org.simantics.scl.runtime.function.Function4;

/**
 * Re-evaluates the name of the typical instance component corresponding to the
 * specified element. If the template name is not parameterized or the evaluated
 * name already matches the instance component name, the rule does nothing.
 * Otherwise it resets the instance component name.
 * 
 * @author Tuukka Lehtonen
 */
public enum NameRule implements ITypicalSynchronizationRule {

    INSTANCE;

    public static NameRule getInstance() {
        return INSTANCE;
    }

    @Override
    public boolean synchronize(WriteGraph graph, Resource templateElement, Resource instanceElement, TypicalInfo info) throws DatabaseException {
    	
        Function4<ReadGraph, Resource, Resource, String, String> namingFunction = info.bean.getAux(AuxKeys.KEY_TYPICAL_NAMING_FUNCTION);
        if (namingFunction == null)
            return false;

        ModelingResources MOD = ModelingResources.getInstance(graph);
        Resource instanceComponent = graph.getPossibleObject(instanceElement, MOD.ElementToComponent);
        if (instanceComponent == null)
            return false;

        boolean result = TypicalUtil.applyTypicalModuleName(graph, instanceComponent, namingFunction, null); 
        if(result) info.messageLog.add("\t\t\tname");
        
        return result;
        
    }

}
