/*******************************************************************************
 * Copyright (c) 2007, 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.typicals;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.serialization.SerializationException;
import org.simantics.databoard.serialization.Serializer;
import org.simantics.db.Metadata;
import org.simantics.db.Resource;
import org.simantics.db.Session;

/**
 * @author Tuukka Lehtonen
 */
public class TypicalSynchronizationMetadata implements Metadata {

    private static final Binding BINDING = 
            Bindings.getBindingUnchecked(TypicalSynchronizationMetadata.class);
    private static final Serializer SERIALIZER = 
            Bindings.getSerializerUnchecked(BINDING);

    public List<Resource> synchronizedTypicals;

    public TypicalSynchronizationMetadata() {
    }

    @Override
    public byte[] serialise(Session session) {
        try {
            return SERIALIZER.serialize(this);
        } catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public static TypicalSynchronizationMetadata deserialise(Session session, byte[] input) {
        if (input == null) {
            TypicalSynchronizationMetadata metadata = new TypicalSynchronizationMetadata();
            metadata.synchronizedTypicals = new ArrayList<Resource>();
            return metadata;
        }
        try {
            return (TypicalSynchronizationMetadata) SERIALIZER.deserialize(input);
        } catch (SerializationException e) {
            e.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    /**
     * @param typicalInstance
     * @return
     */
    public TypicalSynchronizationMetadata addTypical(Resource typicalInstance) {
        synchronizedTypicals.add(typicalInstance);
        return this;
    }

    public List<Resource> getTypicals() {
        return synchronizedTypicals;
    }

}
