/*******************************************************************************
 * Copyright (c) 2007, 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.typicals;

import java.util.Map;
import java.util.Set;

import org.simantics.databoard.Bindings;
import org.simantics.databoard.annotations.Identifier;
import org.simantics.databoard.annotations.Optional;
import org.simantics.databoard.binding.Binding;
import org.simantics.databoard.util.Bean;
import org.simantics.db.Resource;

/**
 * Information structure for a single typical diagram instance diagram.
 * 
 * @author Tuukka Lehtonen
 */
public class TypicalInfoBean extends Bean.Id {

    public static final Binding BINDING = Bindings.getBindingUnchecked(TypicalInfoBean.class);

    /**
     * All DIA.Elements in the typical diagram instance.
     */
    @Identifier public Set<Resource>           instanceElements;

    /**
     * Maps all typical diagram instance elements to template elements where
     * a MOD.HasElementSource mapping exists.
     */
    @Identifier public Map<Resource, Resource> instanceToTemplate;

    /**
     * Inverse map of {@link #instanceToTemplate}
     */
    public Map<Resource, Resource>             templateToInstance;

    /**
     * Describes the set of DIA.Elements that are marked with
     * MOD.IsTemplatized tag.
     */
    @Identifier public Set<Resource>           isTemplatized;

    /**
     * Current set of template diagram elements.
     */
    @Optional public transient Set<Resource>   templateElements;

    /**
     * Auxiliary transient data passed on during synchronization.
     */
    @Optional public transient Map<Object, Object> auxiliary;

    public TypicalInfoBean() {
        super(BINDING);
    }

    @SuppressWarnings("unchecked")
    public <T> T getAux(Object key) {
        return auxiliary == null ? null : (T) auxiliary.get(key);
    }

}