package org.simantics.modeling.typicals;

import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;

/**
 * Represents a single or composed synchronization operation from a typical
 * template diagram element to an instance of the same element.
 * 
 * @author Tuukka Lehtonen
 */
public interface ITypicalSynchronizationRule {

    /**
     * @param graph
     * @param template the template source of synchronization
     * @param instance the target instance of synchronization
     * @param info
     * @return <code>true</code> if synchronization made changes to the database
     * @throws DatabaseException
     */
    boolean synchronize(WriteGraph graph, Resource template, Resource instance, TypicalInfo info)
            throws DatabaseException;

}
