/*******************************************************************************
 * Copyright (c) 2007, 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.typicals;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.NamedResource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ModelingResources;

public class AvailableSynchronizationRules extends ResourceRead<Collection<NamedResource>> {

	public AvailableSynchronizationRules(Resource resource) {
		super(resource);
	}

	@Override
	public Collection<NamedResource> perform(ReadGraph graph)
			throws DatabaseException {

		Layer0 L0 = Layer0.getInstance(graph);
		DiagramResource DIA = DiagramResource.getInstance(graph);

		Set<Resource> rules = new HashSet<Resource>();
		tryAddRules(graph, resource, rules);
		for (Resource element : graph.syncRequest(new ObjectsWithType(resource, L0.ConsistsOf, DIA.Element))) {
			tryAddRules(graph, element, rules);
		}

		Collection<NamedResource> result = new ArrayList<>();
		for(Resource rule : rules) {
			String name = NameUtils.getSafeLabel(graph, rule);
			result.add(new NamedResource(name, rule));
		}

		return result;
	}

	private int tryAddRules(ReadGraph graph, Resource r, Set<Resource> rules) throws DatabaseException {
		ModelingResources MOD = ModelingResources.getInstance(graph);
		int count = 0;
		for (Resource ruleResource : graph.getObjects(r, MOD.HasTypicalSynchronizationRule)) {
			ITypicalSynchronizationRule rule = graph.getPossibleAdapter(ruleResource, ITypicalSynchronizationRule.class);
			if (rule != null && rules.add(ruleResource))
				++count;
		}
		return count;
	}

}