/*******************************************************************************
 * Copyright (c) 2007 VTT Technical Research Centre of Finland and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.subscription;

import org.simantics.databoard.annotations.Identifier;
import org.simantics.databoard.annotations.Optional;
import org.simantics.databoard.util.Bean;
import org.simantics.utils.strings.AlphanumComparator;

/**
 * @author Antti Villberg
 */
public class SubscriptionItem extends Bean {
	
	// Normal Label (eg. The label in CSV file)
	public @Optional String simpleLabel;
	// Variable reference in user friendly format
	public @Optional String variableReference;
	
	// GroupId in the history
	public @Identifier String groupId;
	// ItemId in the group
	public @Identifier String groupItemId;
	// Variable id in format understood by org.simantics.simulation.data.Datasource
	public @Identifier String variableId;
	
	public @Optional String unit;
	
	public SubscriptionItem() {
	}
	
	@Override
	public int compareTo(Bean o) {
		if ( o instanceof SubscriptionItem == false ) return 0;
		SubscriptionItem other = (SubscriptionItem) o;
		
		String myLabel2 = simpleLabel!=null?simpleLabel:"";
		String otLabel2 = other.simpleLabel!=null?other.simpleLabel:"";
		int c = AlphanumComparator.CASE_INSENSITIVE_COMPARATOR.compare(myLabel2, otLabel2);
		if ( c!=0 ) return c;
		
		String mySid = groupId!=null?groupId:""; 
		String otSid = other.groupId!=null?other.groupId:""; 
		c = mySid.compareTo(otSid);
		if ( c!=0 ) return c;

		String myGiid = groupItemId!=null?groupItemId:""; 
		String otGiid = other.groupItemId!=null?other.groupItemId:""; 
		c = myGiid.compareTo(otGiid);
		if ( c!=0 ) return c;

		String myVid = variableId!=null?variableId:""; 
		String otVid = other.variableId!=null?other.variableId:""; 
		c = myVid.compareTo(otVid);
		if ( c!=0 ) return c;
		
		return c;		
	}
	
}

