/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.requests;

import java.util.Collection;

import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.modeling.ModelingResources;

/**
 * @author Tuukka Lehtonen
 */
public class SetSubscriptionEnabled {

    Collection<Resource> subscriptions;
    boolean              newValue;

    public SetSubscriptionEnabled(Collection<Resource> subscriptions, boolean newValue) {
        this.subscriptions = subscriptions;
        this.newValue = newValue;
    }

    public void perform(WriteGraph graph) throws DatabaseException {
        ModelingResources mod = ModelingResources.getInstance(graph);

        Boolean value = newValue;
        //System.out.println("SetEnabled(" + value + "):");
        for (Resource subscription : subscriptions) {
            //System.out.println("    setting for " + NameUtils.getSafeLabel(graph, subscription));
            graph.claimLiteral(subscription, mod.Subscription_Enabled, value);
        }
    }

}