package org.simantics.modeling.query;

import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.ConstantPropertyVariable;
import org.simantics.db.layer0.variable.ProxyChildVariable;
import org.simantics.db.layer0.variable.StandardGraphChildVariable;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;

public class QueryRootVariable extends StandardGraphChildVariable {

    public QueryRootVariable(QueryProxyChildVariable parent, Resource resource) {
        super(parent, null, resource);
    }
    
    @Override
    public String getName(ReadGraph graph) throws DatabaseException {
        return ProxyChildVariable.CONTEXT_END;
    }
    
    @SuppressWarnings("deprecation")
    @Override
    public Variable getNameVariable(ReadGraph graph) throws DatabaseException {
        return new ConstantPropertyVariable(this, Variables.NAME, ProxyChildVariable.CONTEXT_END, Bindings.STRING);
    }
    
}