/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.mapping;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.utils.predicates.UnaryTest;

public class Tag extends UnaryTest {

    Resource tag;
    
    public Tag(Resource tag) {
        this.tag = tag;
    }
    
    @Override
    public boolean has(ReadGraph g, Resource r) throws DatabaseException {
        return g.hasStatement(r, tag);
    }
    
    @Override
    public void add(WriteGraph g, Resource r) throws DatabaseException {
        if(!g.hasStatement(r, tag))
            g.claim(r, tag, r);
    }
    
    @Override
    public void remove(WriteGraph g, Resource r) throws DatabaseException {
        g.deny(r, tag);
    }

}
