/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.mapping;

import org.simantics.db.Resource;
import org.simantics.layer0.utils.binaryPredicates.CompositePredicate;
import org.simantics.layer0.utils.binaryPredicates.IBinaryPredicate;
import org.simantics.layer0.utils.binaryPredicates.Relation;
import org.simantics.layer0.utils.predicates.Conjunction;
import org.simantics.layer0.utils.predicates.Disjunction;
import org.simantics.layer0.utils.predicates.IUnaryPredicate;
import org.simantics.layer0.utils.predicates.Negation;
import org.simantics.layer0.utils.predicates.Type;
import org.simantics.layer0.utils.triggers.Trigger;
import org.simantics.mapping.constraint.instructions.AndInstruction;
import org.simantics.mapping.constraint.instructions.BinaryPredicateInstruction;
import org.simantics.mapping.constraint.instructions.BinaryPredicateObjectQuery;
import org.simantics.mapping.constraint.instructions.BinaryPredicateSubjectQuery;
import org.simantics.mapping.constraint.instructions.ExistsInstruction;
import org.simantics.mapping.constraint.instructions.IInstruction;
import org.simantics.mapping.constraint.instructions.NotInstruction;
import org.simantics.mapping.constraint.instructions.OrInstruction;
import org.simantics.mapping.constraint.instructions.TripletInstruction;
import org.simantics.mapping.constraint.instructions.TripletObjectQuery;
import org.simantics.mapping.constraint.instructions.TripletPredicateObjectQuery;
import org.simantics.mapping.constraint.instructions.TripletSubjectPredicateQuery;
import org.simantics.mapping.constraint.instructions.TypedBracketInstruction;
import org.simantics.mapping.constraint.instructions.TypedBracketInstruction.CreationInstruction;
import org.simantics.mapping.constraint.instructions.UnaryPredicateInstruction;
import org.simantics.mapping.rule.instructions.AndRuleInstruction;
import org.simantics.mapping.rule.instructions.ClaimRuleInstruction;
import org.simantics.mapping.rule.instructions.DenyRuleInstruction;
import org.simantics.mapping.rule.instructions.IRuleInstruction;
import org.simantics.mapping.rule.instructions.IfRuleInstruction;
import org.simantics.mapping.rule.instructions.PrintRuleInstruction;
import org.simantics.mapping.rule.instructions.QueryRuleInstruction;
import org.simantics.mapping.rule.instructions.UnlessRuleInstruction;

public abstract class MappingBase extends Trigger {
	
	public static IInstruction bf(IBinaryPredicate predicate, int variable0, int variable1) {
		return new BinaryPredicateObjectQuery(variable0, variable1, predicate);
	}
	
	public static IInstruction fb(IBinaryPredicate predicate, int variable0, int variable1) {
        return new BinaryPredicateSubjectQuery(variable0, variable1, predicate);
    }
	
	public static IInstruction bf(Resource relation, int variable0, int variable1) {
		return bf(new Relation(relation), variable0, variable1);
	}
	
	public static IInstruction fb(Resource relation, int variable0, int variable1) {
        return fb(new Relation(relation), variable0, variable1);
    }
	
	public static IInstruction bb(IBinaryPredicate predicate, int variable0, int variable1) {
		return new BinaryPredicateInstruction(variable0, variable1, predicate);
	}
	
	public static IInstruction bb(Resource relation, int variable0, int variable1) {
		return bb(new Relation(relation), variable0, variable1);
	}
	
	public static IInstruction b(IUnaryPredicate predicate, int variable0) {
		return new UnaryPredicateInstruction(variable0, predicate);
	}
	
	public static IInstruction b(Resource type, int variable0) {
		return b(new Type(type), variable0);
	}
	
	public static IInstruction statement_ffb(int variable0, int variable1, int variable2) {
		return new TripletSubjectPredicateQuery(variable0, variable1, variable2);
	}
	
	public static IInstruction statement_ffb(int variable0, int variable1, int variable2, Resource baseRelation) {
		return new TripletSubjectPredicateQuery(variable0, variable1, variable2, baseRelation);
	}
	
	public static IInstruction statement_bff(int variable0, int variable1, int variable2) {
		return new TripletPredicateObjectQuery(variable0, variable1, variable2);
	}
	
	public static IInstruction statement_bbf(int variable0, int variable1, int variable2) {
		return new TripletObjectQuery(variable0, variable1, variable2);
	}
	
	public static IInstruction statement_bff(int variable0, int variable1, int variable2, Resource baseRelation) {
		return new TripletPredicateObjectQuery(variable0, variable1, variable2, baseRelation);
	}
	
	public static IInstruction statement(int variable0, int variable1, int variable2) {
		return new TripletInstruction(variable0, variable1, variable2);
	}
	
	public static IInstruction exists(IInstruction constraint, int ... variables) {
		return new ExistsInstruction(constraint, variables);
	}
	
	public static IInstruction exists(int ... variables) {
		return new ExistsInstruction(and(), variables);
	}
	
	public static IInstruction exists(IInstruction constraint, CreationInstruction ... instrs) {
		return new TypedBracketInstruction(constraint, instrs);
	}
	
	public static IInstruction and() {
		return new AndInstruction();
	}

	public static IUnaryPredicate and(IUnaryPredicate ... predicates) {
        return new Conjunction(predicates);
    }	

	public static IUnaryPredicate or(IUnaryPredicate ... predicates) {
        return new Disjunction(predicates);
    }	

	public static IUnaryPredicate not(IUnaryPredicate predicate) {
        return new Negation(predicate);
    }	
	
	public static IUnaryPredicate implies(IUnaryPredicate from, IUnaryPredicate to) {
		return or(not(from), to);
	}

	public static IInstruction and(IInstruction ... constraints) {
		return new AndInstruction(constraints);
	}
	
	public static IInstruction or(IInstruction ... constraints) {
        return new OrInstruction(constraints);
    }	
	
	public static IInstruction not(IInstruction constraint) {
        return new NotInstruction(constraint);
    }
	
	public static IRuleInstruction and(IRuleInstruction ... rules) {
		return new AndRuleInstruction(rules);
	}

	public static IRuleInstruction claim(IInstruction constraint) {
		return new ClaimRuleInstruction(constraint);
	}
	
	public static IRuleInstruction claim(IInstruction ... constraints) {
		return claim(and(constraints));
	}
	
	public static IRuleInstruction claim(IInstruction constraint, IRuleInstruction continuation) {
		return new ClaimRuleInstruction(constraint, continuation);
	}
	
	public static IRuleInstruction deny(IInstruction constraint) {
		return new DenyRuleInstruction(constraint);
	}
	
	public static IRuleInstruction if_(IInstruction condition, IRuleInstruction then) {
		return new IfRuleInstruction(condition, then);
	}
	
	public static IRuleInstruction if_(IInstruction condition, IRuleInstruction then, IRuleInstruction else_) {
		return new IfRuleInstruction(condition, then, else_);
	}

	public static IRuleInstruction unless(IInstruction condition, IRuleInstruction then) {
		return new UnlessRuleInstruction(condition, then);
	}
	
	public static IRuleInstruction query(IRuleInstruction rule) {
		return new QueryRuleInstruction(rule);
	}
	
	public static IRuleInstruction print(String text) {
		return new PrintRuleInstruction(text);
	}
	
	public static IBinaryPredicate compose(Resource a, Resource b) {
		return new CompositePredicate(new Relation(a), new Relation(b)); 
	}
	
	public static IBinaryPredicate compose(Resource a, IBinaryPredicate b) {
		return new CompositePredicate(new Relation(a), b); 
	}
	
	public static IBinaryPredicate compose(IBinaryPredicate a, Resource b) {
		return new CompositePredicate(a, new Relation(b)); 
	}
	
	public static IBinaryPredicate compose(Resource a, Resource b, Resource c) {
		return compose(compose(a, b), c);
	}
}
