package org.simantics.modeling.mapping;

import gnu.trove.map.hash.THashMap;

import java.util.ArrayList;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.mapping.IContextualModification;
import org.simantics.mapping.constraint.instructions.Instruction3;
import org.simantics.modeling.ModelingResources;
import org.simantics.structural.stubs.StructuralResource2;

public class DiagramConnectionExistence extends Instruction3 {

    public DiagramConnectionExistence(int variable0, int variable1,
            int variable2) {
        super(variable0, variable1, variable2);
    }
    
    /* and(bf(MOD.ConnectionRelationToDiagramConnectionRelation, ConnectionRelation, DiagramConnectionRelation),
           statement_bbf(Element, DiagramConnectionRelation, Connector),
           bb(DIA.IsConnectorOf, Connector, Connection2)
          )
     */
    private static class ConnectionsOfElement extends ResourceRead<THashMap<Resource,ArrayList<Resource>>> {
        
        public ConnectionsOfElement(Resource element) {
            super(element);
        }

        @Override
        public THashMap<Resource, ArrayList<Resource>> perform(ReadGraph graph)
                throws DatabaseException {
            THashMap<Resource, ArrayList<Resource>> result =
                    new THashMap<Resource, ArrayList<Resource>>(4);
            StructuralResource2 STR = StructuralResource2.getInstance(graph);
            DiagramResource DIA = DiagramResource.getInstance(graph);            
            ModelingResources MOD = ModelingResources.getInstance(graph);
            for(Statement stat : graph.getStatements(resource, STR.IsConnectedTo)) {
                for(Resource configurationRelation : 
                        graph.getObjects(stat.getPredicate(), 
                                MOD.DiagramConnectionRelationToConnectionRelation)) {
                    ArrayList<Resource> l = result.get(configurationRelation);
                    if(l == null) {
                        l = new ArrayList<Resource>(2);
                        result.put(configurationRelation, l);
                    }
                    l.addAll(graph.getObjects(stat.getObject(), DIA.IsConnectorOf));
                }
            }
            return result;
        }        
    }
    
    @Override
    public Object query(ReadGraph g, Object[] bindings)
            throws DatabaseException {
        Resource element = (Resource)bindings[variable0];
        Resource connectionRelation = (Resource)bindings[variable1];
        Resource connection2 = (Resource)bindings[variable2];
        //System.out.println("query " + element + " " + connectionRelation + " " + connection2);
        
        THashMap<Resource, ArrayList<Resource>> map = g.syncRequest(new ConnectionsOfElement(element)); 
        //System.out.println("    " + map);
        ArrayList<Resource> cs = map.get(connectionRelation);
        if(cs != null && cs.contains(connection2))
            return null;
        else
            return FAILURE;
    }

    @Override
    public Object next(ReadGraph g, Object[] bindings, Object continuation)
            throws DatabaseException {
        return FAILURE;
    }

    @Override
    public IContextualModification claim(ReadGraph g, Object[] bindings)
            throws DatabaseException {
        throw new UnsupportedOperationException();
    }

    @Override
    public IContextualModification deny(ReadGraph g, Object[] bindings)
            throws DatabaseException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void toString(StringBuilder b, int indent) {
        b.append("DiagramConnectionExistence");
    }

}
