package org.simantics.modeling.export;

import java.util.Collection;

import org.simantics.db.ReadGraph;
import org.simantics.db.common.utils.traverser.TraverseQueryBuilder;
import org.simantics.db.common.utils.traverser.TraverseResult;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.export.core.ExportContext;
import org.simantics.export.core.error.ExportException;
import org.simantics.export.core.intf.DiscoverAction;
import org.simantics.export.core.util.ExportQueries;
import org.simantics.layer0.Layer0;
import org.simantics.simulation.ontology.SimulationResource;

/**
 * Discovers all models in context ( session, project )
 *
 * @author toni.kalajainen@semantum.fi
 */
public class DiscoverModels implements DiscoverAction {

	public Read<Collection<String>> discoverRequest(
			final Collection<String> startLocations) throws ExportException {
		return new Read<Collection<String>>() {
			public Collection<String> perform(ReadGraph graph) throws DatabaseException {
				
				Layer0 L0 = Layer0.getInstance(graph);
				SimulationResource SIM = SimulationResource.getInstance(graph);  
				TraverseQueryBuilder builder = new TraverseQueryBuilder();
				builder.setStartResources( graph.syncRequest( ExportQueries.toResources(startLocations) ) );
				builder.followRelation( L0.ConsistsOf );
				builder.followAndReturnInstanceOf( SIM.Model );
				TraverseResult traverseResult = graph.syncRequest( builder.build() );
				return graph.syncRequest( ExportQueries.toUris( traverseResult.result ) );
			}
			
		};
	}

	@Override
	public Collection<String> discoverContent(ExportContext ctx, Collection<String> startLocations) throws ExportException {		
		try {
			return ctx.session.syncRequest( discoverRequest(startLocations) );
		} catch (DatabaseException e) {
			if ( e.getCause() instanceof ExportException ) throw (ExportException) e.getCause();
			throw new ExportException( e );
		}
	}
	

}
