package org.simantics.modeling.adapters;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.Simantics;
import org.simantics.browsing.ui.model.images.ImageRule;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.modeling.ModelingResources;
import org.simantics.scl.runtime.function.Function1;
import org.simantics.scl.runtime.tuple.Tuple;

public class SCLImageRule implements ImageRule {

    private Resource rule;
    
    public SCLImageRule(ReadGraph graph, Resource rule) {
        this.rule = rule;
    }
    
    @Override
    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Resource.class) || contentType.equals(Variable.class);
    }

    @Override
    public Map<String, ImageDescriptor> getImage(ReadGraph graph, Object content) throws DatabaseException {
        ModelingResources MOD = ModelingResources.getInstance(graph);
        
        Variable ruleVariable = Variables.getVariable(graph, rule);

        Function1<Object,List<Tuple>> getImages = ruleVariable.getPossiblePropertyValue(graph, MOD.SCLImageRule_getImages);
        if(getImages == null) return Collections.emptyMap();

        List<Tuple> value = Simantics.applySCLRead(graph, getImages, content);
        Map<String,ImageDescriptor> result = new HashMap<>();
        for(Tuple t : value) {
        	result.put((String)t.get(0), (ImageDescriptor)t.get(1));
        }
        return result;
        
    }

}
