/*******************************************************************************
 * Copyright (c) 2019 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.adapters;

import org.simantics.browsing.ui.CheckedState;
import org.simantics.browsing.ui.model.check.CheckedStateRule;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.VariableOrResource;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.modeling.ModelingResources;
import org.simantics.scl.runtime.SCLContext;
import org.simantics.scl.runtime.function.Function1;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCLCheckedStateRule implements CheckedStateRule {

    private static final Logger LOGGER = LoggerFactory.getLogger(SCLCheckedStateRule.class);

    private Resource rule;

    public SCLCheckedStateRule(ReadGraph graph, Resource rule) {
        this.rule = rule;
    }

    @Override
    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(Resource.class) || contentType.equals(Variable.class);
    }

    @Override
    public CheckedState getCheckedState(ReadGraph graph, Object content) throws DatabaseException {

        ModelingResources MOD = ModelingResources.getInstance(graph);

        Variable ruleVariable = Variables.getVariable(graph, rule);

        Function1<Object,CheckedState> getLabels = ruleVariable.getPossiblePropertyValue(graph, MOD.SCLCheckedStateRule_getState);
        if(getLabels == null) {
            LOGGER.warn("Didn't find value for subject={}, predicate={}.", rule, ModelingResources.URIs.SCLCheckedStateRule_getState);
            return CheckedState.NOT_CHECKED;
        }

        SCLContext sclContext = SCLContext.getCurrent();
        Object oldGraph = sclContext.get("graph");
        try {
            sclContext.put("graph", graph);
            return getLabels.apply(VariableOrResource.make(content));
        } catch (Throwable t) {
            LOGGER.error("Calculating checked state failed.", t);
            throw new DatabaseException(t);
        } finally {
            sclContext.put("graph", oldGraph);
        }

    }

}
