/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.adapters;

import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.OrderedSetUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.Remover;
import org.simantics.db.layer0.adapter.impl.EntityRemover;
import org.simantics.layer0.utils.binaryPredicates.OrderedSetElementsPredicate;

/**
 * A {@link Remover} implementation for removing DIA.Monitor instances.
 * 
 * TODO: see why we couldn't just use ElementRemover for monitors? Previously
 * DIA.Monitors were explicitly declared in adapters.xml to adapt to
 * EntityRemover, not ElementRemover. There had to be some reason for that
 * choice.
 * 
 * @author Tuukka Lehtonen
 */
public class MonitorRemover extends EntityRemover {

    private static final boolean DEBUG = false;

    public MonitorRemover(Resource element) throws DatabaseException {
        super(element);
    }

    @Override
    public void remove(WriteGraph graph) throws DatabaseException {
        if (DEBUG)
            System.out.println(this + " removing monitor");

        // 1. Disconnect element from diagrams
        for (Resource diagram : OrderedSetElementsPredicate.INSTANCE.getSubjects(graph, resource)) {
            OrderedSetUtils.remove(graph, diagram, resource);
        }

        // 2. Delete element itself
        EntityRemover.remove(graph, resource);
    }

    @Override
    public String toString() {
        return getClass().getSimpleName() + resource;
    }

}
