/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.adapters;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.Statement;
import org.simantics.db.layer0.adapter.SubgraphAdvisor;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.modeling.ModelingResources;

public class MappingSubgraphAdvisor implements SubgraphAdvisor {

	@Override
	public void advise(AsyncReadGraph graph, Statement statement, AsyncProcedure<Boolean> procedure) {
		ModelingResources mr = graph.getService(ModelingResources.class);
		if(mr.CompositeToDiagram.equals(statement.getPredicate())) procedure.execute(graph, true);
		else procedure.execute(graph, false);
	}

	@Override
	public double priority() {
		return 0;
	}

}
