/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.adapters;

import org.simantics.db.AsyncReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Statement;
import org.simantics.db.layer0.adapter.impl.TypeSubgraphExtent;
import org.simantics.db.procedure.AsyncProcedure;
import org.simantics.diagram.stubs.DiagramResource;

public class DiagramSubgraphExtent extends TypeSubgraphExtent {

	final private Classifier classifier = new Classifier() {

		@Override
		public void classify(AsyncReadGraph graph, Statement statement, ExtentStatus objectExtent,
				Callback callback) {

			if(!ExtentStatus.INTERNAL.equals(objectExtent)) return;
			
			Resource predicate = statement.getPredicate();
			
			DiagramResource dr = graph.getService(DiagramResource.class);
			if(dr.JoinsFlag.equalsResource(predicate)) callback.statement(statement, true);
			else if(dr.FlagIsJoinedBy.equalsResource(predicate)) callback.statement(statement, true);
			
		}
		
	};
	
	@Override
	public void accept(AsyncReadGraph graph, Resource resource,
			AsyncProcedure<Classifier> procedure, Callback callback) {
		procedure.execute(graph, classifier);
	}

}
