package org.simantics.modeling;

import org.simantics.databoard.adapter.AdaptException;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.Variable;

public class VariableStructuralContext extends org.simantics.structural2.scl.VariableStructuralContext {

	final private Variable selfVariable;
	
	public VariableStructuralContext(ReadGraph graph, Variable selfVariable) throws DatabaseException {
		super(graph, selfVariable);
		this.selfVariable = selfVariable;
	}

    public VariableStructuralContext(Variable selfVariable, Variable variable) throws DatabaseException {
    	super(variable);
        this.selfVariable = selfVariable;
    }

	@Override
	public Object getValue(ReadGraph g, Resource attribute, Binding binding) throws DatabaseException, AdaptException {
		ModelingResources MOD = ModelingResources.getInstance(g);
		if(MOD.self.equals(attribute)) return selfVariable;
		return super.getValue(g, attribute, binding);
	}

}
