package org.simantics.modeling;

import gnu.trove.map.hash.THashMap;

import java.util.Map;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.common.uri.UnescapedChildMapOfResource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PropertyInfo;
import org.simantics.db.layer0.request.PropertyInfoRequest;
import org.simantics.db.layer0.request.UnescapedPropertyMapOfResource;
import org.simantics.layer0.Layer0;
import org.simantics.scl.compiler.types.Type;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.utils.datastructures.Pair;

/**
 * Deprecated: Use ComponentTypeSubstructure that supports deep references
 */
@Deprecated
public class SubstructureMapRequest extends ResourceRead<THashMap<String, Pair<String,Type>>>{

    public SubstructureMapRequest(Resource type) {
        super(type);
    }

    private void collect(ReadGraph graph, Resource t, THashMap<String, Pair<String,Type>> result) throws DatabaseException {
        Layer0 L0 = Layer0.getInstance(graph);
        for(Resource relation : graph.getObjects(t, L0.DomainOf)) {
            if(graph.isSubrelationOf(relation, L0.HasProperty)) {
                PropertyInfo propertyInfo = graph.syncRequest(new PropertyInfoRequest(relation));
                result.put(propertyInfo.name, Pair.make("#" + propertyInfo.name, SCLTypeUtils.getType(propertyInfo)));
            }
        }
    }
    
    @Override
    public THashMap<String, Pair<String,Type>> perform(ReadGraph graph) throws DatabaseException {
        THashMap<String, Pair<String,Type>> propertyMap = new THashMap<String, Pair<String,Type>>();
        StructuralResource2 STR = StructuralResource2.getInstance(graph);
        Resource composite = graph.getPossibleObject(resource, STR.IsDefinedBy);
        if(composite != null) {
	        for(Map.Entry<String, Resource> child : graph.sync(new UnescapedChildMapOfResource(composite)).entrySet()) {
	            for(PropertyInfo property : graph.sync(new UnescapedPropertyMapOfResource(child.getValue())).values()) {
	                propertyMap.put(child.getKey() + "." + property.name,
	                        Pair.make("/" + child.getKey() + "#" + property.name, 
	                                SCLTypeUtils.getType(property)));
	            }
	        }
        }

        collect(graph, resource, propertyMap);
        for(Resource t : graph.getSupertypes(resource)) collect(graph, t, propertyMap);

        return propertyMap;
        
    }

}
