package org.simantics.modeling;

import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.adapter.ActionFactory;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.scl.runtime.function.Function1;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SCLAction implements ActionFactory {

	private static final Logger LOGGER = LoggerFactory.getLogger(SCLAction.class);

	final private Resource rule;
    
    public SCLAction(ReadGraph graph, Resource rule) throws DatabaseException {
    	this.rule = rule;
    }
    
    static class RuleFunctionRequest extends ResourceRead<Function1<Resource,Object>> {

		protected RuleFunctionRequest(Resource rule) {
			super(rule);
		}

		@Override
		public Function1<Resource, Object> perform(ReadGraph graph) throws DatabaseException {
	        Variable ruleVariable = Variables.getVariable(graph, resource);
	        ModelingResources MOD = ModelingResources.getInstance(graph);
	        return ruleVariable.getPossiblePropertyValue(graph, MOD.SCLAction_action);
		}
    	
    }
    
    public static class SCLActionRunnable implements Runnable {
    	
    	public Resource rule;
    	public Resource target;
    	
    	public SCLActionRunnable(Resource rule, Resource target) {
    		this.rule = rule;
    		this.target = target;
    	}
    	
		@Override
		public void run() {
			Resource resource = (Resource)target;
			Simantics.getSession().markUndoPoint();
			try {
				Function1<Resource, Object> function = Simantics.getSession().syncRequest(new RuleFunctionRequest(rule));
				function.apply(resource);
			} catch (DatabaseException e) {
				LOGGER.error("SCLActionRunnable failed to request/apply RuleFunction {}", rule, e);
			}
		}
    	
    }

	@Override
	public Runnable create(final Object target) {
		return new SCLActionRunnable(rule, (Resource)target);
	}

}
