package org.simantics.modeling;

import gnu.trove.map.hash.THashMap;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.PropertyInfo;
import org.simantics.db.layer0.request.PropertyInfoRequest;
import org.simantics.db.layer0.request.VariableRead;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.scl.compiler.types.Type;
import org.simantics.utils.datastructures.Pair;

public class ProceduralSubstructureMapRequest extends VariableRead<THashMap<String, Pair<String,Type>>>{

    public ProceduralSubstructureMapRequest(Variable composite) {
        super(composite);
    }

    @Override
    public THashMap<String, Pair<String,Type>> perform(ReadGraph graph) throws DatabaseException {
        THashMap<String, Pair<String,Type>> propertyMap = new THashMap<String, Pair<String,Type>>();
        for(Variable child : variable.getChildren(graph)) {
            for(Variable property : child.getProperties(graph)) {
                Resource predicate = property.getPossiblePredicateResource(graph);
                if (predicate == null)
                    continue;
                
                PropertyInfo propertyInfo = graph.syncRequest(new PropertyInfoRequest(predicate));
                propertyMap.put(child.getName(graph) + "." + propertyInfo.name,
                        Pair.make("/" + child.getName(graph) + "#" + propertyInfo.name,
                                SCLTypeUtils.getType(propertyInfo)));
            }
        }
        for(Variable property : variable.getProperties(graph)) {
            Resource predicate = property.getPossiblePredicateResource(graph);
            if (predicate == null)
                continue;
            
            PropertyInfo propertyInfo = graph.syncRequest(new PropertyInfoRequest(predicate));
            propertyMap.put(propertyInfo.name,
                    Pair.make("#" + propertyInfo.name,
                            SCLTypeUtils.getType(propertyInfo)));
        }
        
        return propertyMap;
    }

}
