package org.simantics.modeling;

import java.util.Set;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.scl.compiler.environment.LocalEnvironment;
import org.simantics.scl.compiler.environment.specification.EnvironmentSpecification;

public interface IComponentTypeScriptEnvironmentFactory {

    /**
     * Return the EnvironmentSpecification used to initialize the runtime environment for this script
     * 
     * @param graph
     * @param componentType
     * @return the runtime enviroment
     * @throws DatabaseException
     */
    public EnvironmentSpecification getRuntimeEnvironmentSpecification(ReadGraph graph, Resource componentType) throws DatabaseException;
    
    /**
     * Return a local environment for this script if one is needed
     * 
     * @param graph
     * @param componentType
     * @return the local environment or null
     * @throws DatabaseException
     */
    public LocalEnvironment getLocalEnvironment(ReadGraph graph, Resource componentType) throws DatabaseException;
    
    /**
     * Get the set of all modules the local environment returned by getLocalEnvironment reads from
     * 
     * @param environment
     * @return a set of module names or null
     */
    public Set<String> getModuleReads(LocalEnvironment environment);
    
    /**
     * Get the set of all modules the local environment returned by getLocalEnvironment writes to
     * 
     * @param environment
     * @return a set of module names or null
     */
    public Set<String> getModuleWrites(LocalEnvironment environment);
    
}
