package org.simantics.modeling;

import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.common.request.ParametrizedPrimitiveRead;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.Listener;
import org.simantics.scl.compiler.environment.specification.EnvironmentSpecification;
import org.simantics.scl.compiler.module.repository.ImportFailureException;
import org.simantics.scl.compiler.module.repository.UpdateListener;
import org.simantics.scl.compiler.runtime.RuntimeEnvironment;
import org.simantics.scl.osgi.SCLOsgi;
import org.simantics.scl.runtime.SCLContext;

public class ComponentTypeScriptRuntimeEnvironmentRequest extends ParametrizedPrimitiveRead<EnvironmentSpecification, RuntimeEnvironment> {
    UpdateListener listener;
    boolean registered = true;

    public ComponentTypeScriptRuntimeEnvironmentRequest(EnvironmentSpecification parameter) {
        super(parameter);
    }

    private class UL extends UpdateListener {
        private Listener<RuntimeEnvironment> procedure;

        public UL(Listener<RuntimeEnvironment> procedure) {
            this.procedure = procedure;
        }

        @Override
        public void notifyAboutUpdate() {
            if (!registered)
                return;

            var processor = Simantics.getAvailableRequestProcessor();
            if (processor instanceof ReadGraph g) {
                createRuntimeEnvironment(g, procedure, this);
            } else {
                Simantics.getSession().asyncRequest(new ReadRequest() {
                    @Override
                    public void run(ReadGraph graph) throws DatabaseException {
                        if (registered) {
                            createRuntimeEnvironment(graph, procedure, UL.this);
                        }
                    }
                });
            }
        }
    };

    @Override
    public void register(ReadGraph graph, Listener<RuntimeEnvironment> procedure) {
        if(!procedure.isDisposed() && listener == null) {
            listener = new UL(procedure);
        }
        createRuntimeEnvironment(graph, procedure, listener);
    }

    @Override
    public void unregistered() {
        registered = false;
        if(listener != null)
            listener.stopListening();
    }

    private void createRuntimeEnvironment(ReadGraph graph, Listener<RuntimeEnvironment> procedure, UpdateListener listener) {
        SCLContext context = SCLContext.getCurrent();
        Object oldGraph = context.put("graph", graph);
        try {
            procedure.execute(SCLOsgi.MODULE_REPOSITORY.createRuntimeEnvironment(parameter, ComponentTypeScriptRuntimeEnvironmentRequest.class.getClassLoader(), listener));
        }
        catch (ImportFailureException e) {
            procedure.exception(e);
        }
        finally {
            context.put("graph", oldGraph);
        }
    }

}
