/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.jfreechart.chart.properties;

import java.util.Collection;
import org.simantics.browsing.ui.swt.widgets.impl.SelectionListenerImpl;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.WriteOnlyGraph;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;

public class BooleanSelectionListener
extends SelectionListenerImpl<Resource> {
    private final String propertyURI;
    private final String typeUri;
    private final boolean defaultValue;

    public BooleanSelectionListener(ISessionContext context, String propertyURI) {
        this(context, null, propertyURI, false);
    }

    public BooleanSelectionListener(ISessionContext context, String typeUri, String propertyURI, boolean defaultValue) {
        super(context);
        this.propertyURI = propertyURI;
        this.typeUri = typeUri;
        this.defaultValue = defaultValue;
    }

    public BooleanSelectionListener(ISessionContext context, String typeUri, String propertyURI) {
        this(context, typeUri, propertyURI, false);
    }

    public void apply(WriteGraph graph, Resource chart) throws DatabaseException {
        if (this.typeUri == null) {
            this.setValue(graph, chart);
        } else {
            Resource type = graph.getResource(this.typeUri);
            for (Resource object : (Collection)graph.syncRequest((Read)new ObjectsWithType(chart, Layer0.getInstance((ReadGraph)graph).ConsistsOf, type))) {
                this.setValue(graph, object);
            }
        }
    }

    private void setValue(WriteGraph graph, Resource resource) throws DatabaseException {
        Resource property = graph.getResource(this.propertyURI);
        Boolean value = (Boolean)graph.getPossibleRelatedValue(resource, property, (Binding)Bindings.BOOLEAN);
        if (value == null) {
            graph.claimLiteral(resource, property, (Object)(!this.defaultValue ? 1 : 0));
            Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)("Modified " + String.valueOf(graph.getPossibleRelatedValue2(property, Layer0.getInstance((ReadGraph)graph).HasName, (Binding)Bindings.STRING)) + " for " + String.valueOf(graph.getPossibleRelatedValue2(resource, Layer0.getInstance((ReadGraph)graph).HasLabel, (Binding)Bindings.STRING)) + " to " + !this.defaultValue));
        } else {
            boolean newValue = Boolean.FALSE.equals(value);
            graph.claimLiteral(resource, property, (Object)newValue);
            Layer0Utils.addCommentMetadata((WriteOnlyGraph)graph, (String)("Modified " + String.valueOf(graph.getPossibleRelatedValue2(property, Layer0.getInstance((ReadGraph)graph).HasName, (Binding)Bindings.STRING)) + " for " + String.valueOf(graph.getPossibleRelatedValue2(resource, Layer0.getInstance((ReadGraph)graph).HasLabel, (Binding)Bindings.STRING)) + " to " + newValue));
        }
    }
}

