/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.jfreechart.chart.properties;

import java.util.Collection;
import java.util.Iterator;
import org.simantics.browsing.ui.swt.widgets.impl.ReadFactoryImpl;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ObjectsWithType;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Read;
import org.simantics.layer0.Layer0;
import org.simantics.utils.datastructures.Quad;

public class BooleanPropertyFactory
extends ReadFactoryImpl<Resource, Boolean> {
    private final String propertyURI;
    private final String typeURI;
    private final Boolean inverse;
    private final Boolean defaultValue;

    public BooleanPropertyFactory(String propertyURI) {
        this(null, propertyURI, false);
    }

    public BooleanPropertyFactory(String propertyURI, boolean inverse) {
        this(null, propertyURI, inverse);
    }

    public BooleanPropertyFactory(String typeURI, String propertyURI, boolean inverse) {
        this(typeURI, propertyURI, inverse, false);
    }

    public BooleanPropertyFactory(String typeURI, String propertyURI, boolean inverse, boolean defaultValue) {
        this.propertyURI = propertyURI;
        this.inverse = inverse;
        this.typeURI = typeURI;
        this.defaultValue = defaultValue;
    }

    public Object getIdentity(Object inputContents) {
        return new Quad((Object)((Resource)inputContents), (Object)this.propertyURI, ((Object)((Object)this)).getClass(), (Object)this.defaultValue);
    }

    public Boolean perform(ReadGraph graph, Resource r) throws DatabaseException {
        if (this.typeURI == null) {
            return this.getValue(graph, r);
        }
        Resource type = graph.getResource(this.typeURI);
        Iterator iterator = ((Collection)graph.syncRequest((Read)new ObjectsWithType(r, Layer0.getInstance((ReadGraph)graph).ConsistsOf, type))).iterator();
        if (iterator.hasNext()) {
            Resource o = (Resource)iterator.next();
            return this.getValue(graph, o);
        }
        return false;
    }

    private Boolean getValue(ReadGraph graph, Resource resource) throws DatabaseException {
        Boolean value = (Boolean)graph.getPossibleRelatedValue(resource, graph.getResource(this.propertyURI), (Binding)Bindings.BOOLEAN);
        if (value != null) {
            return !this.inverse.equals(value);
        }
        return this.defaultValue;
    }
}

