/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.jfreechart.chart.element;

import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.JFreeChart;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.DiagramUtils;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.SceneGraphNodeKey;
import org.simantics.g2d.element.handler.HandleMouseEvent;
import org.simantics.g2d.element.handler.InternalSize;
import org.simantics.g2d.element.handler.PropertySetter;
import org.simantics.g2d.element.handler.SceneGraph;
import org.simantics.jfreechart.chart.element.ChartElementFactory;
import org.simantics.jfreechart.chart.element.ChartNode;
import org.simantics.jfreechart.chart.element.ResizeListener;
import org.simantics.scenegraph.Node;
import org.simantics.scenegraph.g2d.G2DParentNode;
import org.simantics.scenegraph.g2d.IG2DNode;
import org.simantics.scenegraph.g2d.events.MouseEvent;
import org.simantics.utils.datastructures.hints.IHintContext;
import org.simantics.utils.datastructures.hints.IHintListener;
import org.simantics.utils.datastructures.hints.IHintObservable;

public class ChartSceneGraph
implements SceneGraph,
HandleMouseEvent,
InternalSize {
    private static final long serialVersionUID = 1875762898776996989L;
    public static final IHintContext.Key KEY_SG_NODE = new SceneGraphNodeKey(Node.class, "CHART_SG_NODE");
    public static final IHintContext.Key KEY_SG_SELECTION_NODE = new SceneGraphNodeKey(Node.class, "CHART_SG_SELECTION_NODE");
    protected IHintListener hoverHintListener;

    public Rectangle2D getBounds(IElement e, Rectangle2D s) {
        if (s == null) {
            s = new Rectangle2D.Double();
        }
        IG2DNode node = (IG2DNode)e.getHint(KEY_SG_NODE);
        AffineTransform at = (AffineTransform)e.getHint(ElementHints.KEY_TRANSFORM);
        if (at != null && node != null && node.getBoundsInLocal() != null) {
            Rectangle2D shape = node.getBoundsInLocal();
            Rectangle2D r = shape.getBounds2D();
            double scaleX = at.getScaleX();
            double scaleY = at.getScaleY();
            ChartNode.expand(r, 1.0 * scaleX, 1.0 * scaleY);
            shape = r;
            s.setFrame(shape.getBounds2D());
        } else {
            s.setFrame((Rectangle2D)e.getHint(ElementHints.KEY_BOUNDS));
        }
        return s;
    }

    public void cleanup(IElement e) {
        Node node;
        if (this.hoverHintListener != null) {
            e.removeHintListener(this.hoverHintListener);
        }
        if ((node = (Node)e.removeHint(KEY_SG_NODE)) != null) {
            node.remove();
        }
    }

    public void init(final IElement e, G2DParentNode parent) {
        ChartNode node = (ChartNode)((Object)e.getHint(KEY_SG_NODE));
        if (node == null) {
            node = (ChartNode)((Object)parent.getOrCreateNode("chart_" + e.hashCode(), ChartNode.class));
            Rectangle2D bounds = (Rectangle2D)e.getHint(ElementHints.KEY_BOUNDS);
            if (bounds == null) {
                bounds = new Rectangle2D.Double(-40.0, -40.0, 80.0, 80.0);
                e.setHint(ElementHints.KEY_BOUNDS, (Object)bounds);
            }
            node.setBounds(bounds);
            JFreeChart chart = (JFreeChart)e.getHint(ChartElementFactory.KEY_CHART);
            if (chart != null) {
                node.setChart(chart);
            }
            node.setResizeListener(new ResizeListener(){

                @Override
                public void elementResized(Rectangle2D newBounds) {
                    e.setHint(ElementHints.KEY_BOUNDS, (Object)newBounds);
                    IDiagram diagram = ElementUtils.getDiagram((IElement)e);
                    DiagramUtils.synchronizeHintsToBackend((IDiagram)diagram, (IElement[])new IElement[]{e});
                }
            });
            e.setHint(KEY_SG_NODE, (Object)node);
        }
        this.hoverHintListener = new IHintListener(){

            public void hintRemoved(IHintObservable sender, IHintContext.Key key, Object oldValue) {
            }

            public void hintChanged(IHintObservable sender, IHintContext.Key key, Object oldValue, Object newValue) {
                IElement e;
                ChartNode name;
                if (key == ElementHints.KEY_HOVER && (name = (ChartNode)((Object)(e = (IElement)sender).getHint(KEY_SG_NODE))) != null) {
                    name.setHover(Boolean.TRUE.equals(e.getHint(ElementHints.KEY_HOVER)));
                }
            }
        };
        e.addHintListener(this.hoverHintListener);
        this.update(e);
    }

    public void update(IElement e) {
        PropertySetter setter = (PropertySetter)e.getElementClass().getSingleItem(PropertySetter.class);
        setter.syncPropertiesToNode(e);
    }

    public boolean handleMouseEvent(IElement e, ICanvasContext ctx, MouseEvent me) {
        if (me instanceof MouseEvent.MouseEnterEvent) {
            e.setHint(ElementHints.KEY_HOVER, (Object)true);
        } else if (me instanceof MouseEvent.MouseExitEvent) {
            e.setHint(ElementHints.KEY_HOVER, (Object)false);
        }
        return false;
    }
}

