/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.jfreechart.chart.element;

import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.JFreeChart;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Write;
import org.simantics.diagram.adapter.ElementFactory;
import org.simantics.diagram.adapter.SyncElementFactory;
import org.simantics.diagram.elements.ElementPropertySetter;
import org.simantics.diagram.synchronization.CompositeHintSynchronizer;
import org.simantics.diagram.synchronization.IHintSynchronizer;
import org.simantics.diagram.synchronization.SynchronizationHints;
import org.simantics.diagram.synchronization.graph.DiagramGraphUtil;
import org.simantics.diagram.synchronization.graph.RemoveElement;
import org.simantics.diagram.synchronization.graph.TransformSynchronizer;
import org.simantics.diagram.ui.DiagramModelHints;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.element.handler.ElementHandler;
import org.simantics.g2d.element.handler.LifeCycle;
import org.simantics.g2d.element.handler.impl.DefaultTransform;
import org.simantics.g2d.element.handler.impl.StaticObjectAdapter;
import org.simantics.g2d.element.handler.impl.StaticSymbolImageInitializer;
import org.simantics.g2d.element.handler.impl.StaticSymbolImpl;
import org.simantics.g2d.image.Image;
import org.simantics.g2d.image.impl.ShapeImage;
import org.simantics.jfreechart.chart.IJFreeChart;
import org.simantics.jfreechart.chart.element.ChartBoundsOutline;
import org.simantics.jfreechart.chart.element.ChartSceneGraph;
import org.simantics.sysdyn.JFreeChartResource;
import org.simantics.utils.datastructures.hints.IHintContext;

public class ChartElementFactory
extends SyncElementFactory {
    private static final String CLASS_ID = "Chart";
    public static final ElementFactory INSTANCE = new ChartElementFactory();
    public static final Image STATIC_IMAGE = new ShapeImage(ChartElementFactory.getChartShape(), null, (Stroke)new BasicStroke(1.0f), true);
    public static final double SYMBOL_CHART_SIZE = 10.0;
    public static final IHintContext.Key KEY_CHART_COMPONENT = new IHintContext.KeyOf(Resource.class, "CHART_COMPONENT");
    public static final IHintContext.Key KEY_CHART = new IHintContext.KeyOf(JFreeChart.class, "CHART");
    private static final IHintSynchronizer HINT_SYNCHRONIZER = new CompositeHintSynchronizer(new IHintSynchronizer[]{TransformSynchronizer.INSTANCE});

    static Shape getChartShape() {
        Path2D.Double path = new Path2D.Double();
        ((Path2D)path).moveTo(-10.0, -10.0);
        ((Path2D)path).lineTo(-10.0, 10.0);
        ((Path2D)path).lineTo(10.0, 10.0);
        QuadCurve2D.Double curve = new QuadCurve2D.Double(-9.0, 9.0, 5.0, 5.0, 9.0, -7.0);
        path.append(curve, false);
        return path;
    }

    public static ElementClass create(ReadGraph graph, Resource chart) throws DatabaseException {
        return ElementClass.compile((ElementHandler[])new ElementHandler[]{new ChartSceneGraph(), new Initializer(chart), new StaticObjectAdapter((Object)JFreeChartResource.getInstance((ReadGraph)graph).ChartElement), DefaultTransform.INSTANCE, StaticSymbolImageInitializer.INSTANCE, new StaticSymbolImpl(STATIC_IMAGE), new ChartBoundsOutline(new Rectangle2D.Double(-20.0, -20.0, 60.0, 40.0)), new ElementPropertySetter(ChartSceneGraph.KEY_SG_NODE)}).setId(CLASS_ID);
    }

    public ElementClass create(ReadGraph graph, ICanvasContext canvas, IDiagram diagram, Resource elementType) throws DatabaseException {
        return ChartElementFactory.create(graph, null);
    }

    public void load(ReadGraph g, ICanvasContext canvas, final IDiagram diagram, Resource element, final IElement e) throws DatabaseException {
        ElementPropertySetter ps = (ElementPropertySetter)e.getElementClass().getSingleItem(ElementPropertySetter.class);
        ps.loadProperties(e, element, g);
        AffineTransform at = DiagramGraphUtil.getAffineTransform((ReadGraph)g, (Resource)element);
        double x = at.getTranslateX();
        double y = at.getTranslateY();
        at.setToRotation(0.0);
        at.setToTranslation(x, y);
        ElementUtils.setTransform((IElement)e, (AffineTransform)at);
        ps.overrideProperty(e, "Transform", (Object)at);
        e.setHint(SynchronizationHints.HINT_SYNCHRONIZER, (Object)HINT_SYNCHRONIZER);
        Object o = e.getHint(KEY_CHART_COMPONENT);
        Resource chartResource = o == null || !(o instanceof Resource) ? g.getPossibleObject(element, JFreeChartResource.getInstance((ReadGraph)g).ChartElement_component) : (Resource)o;
        if (chartResource == null || !g.hasStatement(chartResource)) {
            g.asyncRequest((Write)new WriteRequest(){

                public void perform(WriteGraph graph) throws DatabaseException {
                    new RemoveElement((Resource)diagram.getHint(DiagramModelHints.KEY_DIAGRAM_RESOURCE), (Resource)e.getHint(ElementHints.KEY_OBJECT)).perform(graph);
                }
            });
            return;
        }
        IJFreeChart ichart = (IJFreeChart)g.adapt(chartResource, IJFreeChart.class);
        if (ichart != null) {
            JFreeChart chart = ichart.getChart();
            e.setHint(KEY_CHART, (Object)chart);
        }
    }

    static class Initializer
    implements LifeCycle {
        private static final long serialVersionUID = -5822080013184271204L;
        Object component;

        Initializer(Object component) {
            this.component = component;
        }

        public void onElementCreated(IElement e) {
            if (this.component != null) {
                e.setHint(KEY_CHART_COMPONENT, this.component);
            }
        }

        public void onElementActivated(IDiagram d, IElement e) {
        }

        public void onElementDeactivated(IDiagram d, IElement e) {
        }

        public void onElementDestroyed(IElement e) {
        }
    }
}

