/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.jfreechart.chart;

import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.util.HashMap;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.PieToolTipGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieToolTipGenerator;
import org.jfree.chart.plot.DefaultDrawingSupplier;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.ui.RectangleInsets;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.general.DatasetChangeListener;
import org.simantics.databoard.Bindings;
import org.simantics.databoard.binding.Binding;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.jfreechart.chart.AbstractPlot;
import org.simantics.jfreechart.chart.FilteredDataset;
import org.simantics.jfreechart.chart.IDataset;
import org.simantics.jfreechart.chart.PieDataset;
import org.simantics.jfreechart.chart.PlotProperties;
import org.simantics.sysdyn.JFreeChartResource;

public class PiePlot
extends AbstractPlot {
    protected org.jfree.data.general.PieDataset pieDataset;
    private DatasetChangeListener changeListener;

    public PiePlot(ReadGraph graph, Resource resource) {
        super(graph, resource);
    }

    @Override
    protected Plot newPlot() {
        MyPiePlot plot = new MyPiePlot();
        plot.setToolTipGenerator((PieToolTipGenerator)new StandardPieToolTipGenerator());
        return plot;
    }

    @Override
    public void dispose() {
        this.pieDataset = null;
        this.changeListener = null;
        super.dispose();
    }

    @Override
    protected void getOtherProperties(ReadGraph graph, PlotProperties properties) throws DatabaseException {
        Boolean labelsVisible = (Boolean)graph.getPossibleRelatedValue(this.resource, JFreeChartResource.getInstance((ReadGraph)graph).Plot_visibleLabels, (Binding)Bindings.BOOLEAN);
        properties.otherProperties.put("labelsVisible", labelsVisible);
        Boolean useFilter = (Boolean)graph.getPossibleRelatedValue(this.resource, JFreeChartResource.getInstance((ReadGraph)graph).Filter_used, (Binding)Bindings.BOOLEAN);
        Double filterFraction = (Double)graph.getPossibleRelatedValue(this.resource, JFreeChartResource.getInstance((ReadGraph)graph).Filter_fraction, (Binding)Bindings.DOUBLE);
        properties.otherProperties.put("useFilter", useFilter);
        properties.otherProperties.put("filterFraction", filterFraction);
    }

    @Override
    protected void setPlotProperties(PlotProperties properties) {
        if (!(this.plot instanceof org.jfree.chart.plot.PiePlot)) {
            return;
        }
        final org.jfree.chart.plot.PiePlot piePlot = (org.jfree.chart.plot.PiePlot)this.plot;
        if (!properties.datasets.isEmpty()) {
            Boolean labelsVisible;
            final IDataset ds = properties.datasets.get(0);
            Dataset dataset = ((PieDataset)ds).getDataset();
            if (dataset == null) {
                return;
            }
            if (this.pieDataset != null && this.changeListener != null) {
                this.pieDataset.removeChangeListener(this.changeListener);
            }
            this.pieDataset = (org.jfree.data.general.PieDataset)dataset;
            piePlot.setDataset(this.pieDataset);
            if (this.pieDataset instanceof FilteredDataset) {
                FilteredDataset f = (FilteredDataset)this.pieDataset;
                Boolean useFilter = (Boolean)properties.otherProperties.get("useFilter");
                Double filterFraction = (Double)properties.otherProperties.get("filterFraction");
                if (useFilter != null && filterFraction != null) {
                    f.setFiltering(useFilter);
                    f.setFilterFraction(filterFraction * 0.01);
                    f.updateFiltered();
                } else {
                    f.setFiltering(false);
                }
            }
            if (Boolean.FALSE.equals(labelsVisible = (Boolean)properties.otherProperties.get("labelsVisible"))) {
                piePlot.setLabelGenerator(null);
            } else if (piePlot.getLabelGenerator() == null) {
                piePlot.setLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator());
            }
            this.changeListener = new DatasetChangeListener(){

                public void datasetChanged(DatasetChangeEvent event) {
                    HashMap colorMap = ((PieDataset)ds).getColorMap();
                    HashMap explodedMap = ((PieDataset)ds).getExplodedMap();
                    for (Object o : piePlot.getDataset().getKeys()) {
                        if (!(o instanceof Comparable)) continue;
                        Comparable key = (Comparable)o;
                        if (explodedMap.containsKey(key) && explodedMap.get(key).booleanValue()) {
                            piePlot.setExplodePercent(key, 0.3);
                            continue;
                        }
                        piePlot.setExplodePercent(key, 0.0);
                    }
                    for (Comparable name : explodedMap.keySet()) {
                        Boolean exploded = explodedMap.get(name);
                        if (!Boolean.TRUE.equals(exploded)) continue;
                        piePlot.setExplodePercent(name, 0.3);
                    }
                    piePlot.clearSectionPaints(false);
                    piePlot.setDrawingSupplier((DrawingSupplier)new DefaultDrawingSupplier());
                    for (Comparable name : colorMap.keySet()) {
                        piePlot.setSectionPaint(name, (Paint)colorMap.get(name));
                    }
                }
            };
            this.pieDataset.addChangeListener(this.changeListener);
        }
        piePlot.setInsets(new RectangleInsets(0.0, 0.0, 0.0, 0.0), false);
        piePlot.setOutlineVisible(false);
        piePlot.setLabelBackgroundPaint((Paint)Color.WHITE);
        piePlot.setLabelFont(new Font("helvetica", 0, 11));
        super.setPlotProperties(properties);
    }

    protected static class MyPiePlot
    extends org.jfree.chart.plot.PiePlot {
        private static final long serialVersionUID = -5917620061541212934L;

        protected MyPiePlot() {
        }

        public boolean equals(Object obj) {
            boolean result = super.equals(obj);
            if (result) {
                org.jfree.chart.plot.PiePlot that = (org.jfree.chart.plot.PiePlot)obj;
                if (this.getDataset() != that.getDataset()) {
                    return false;
                }
            }
            return result;
        }
    }
}

