/*******************************************************************************
 * Copyright (c) 2007, 2011, 2014 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.jfreechart.chart.properties.xyline;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.simantics.browsing.ui.swt.widgets.Button;
import org.simantics.browsing.ui.swt.widgets.StringPropertyFactory;
import org.simantics.browsing.ui.swt.widgets.StringPropertyModifier;
import org.simantics.browsing.ui.swt.widgets.TrackedText;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.db.management.ISessionContext;
import org.simantics.jfreechart.chart.properties.AxisHidePropertyComposite;
import org.simantics.jfreechart.chart.properties.ColorPicker;
import org.simantics.jfreechart.chart.properties.DoubleValidator;
import org.simantics.jfreechart.chart.properties.JFreeChartPropertyColorProvider;
import org.simantics.layer0.Layer0;
import org.simantics.modeling.ui.chart.property.DoublePropertyFactory;
import org.simantics.modeling.ui.chart.property.DoublePropertyModifier;
import org.simantics.sysdyn.JFreeChartResource;

/**
 * Composite for displaying axis properties in {@link XYLineAxisAndVariablesTab}
 * 
 * @author Teemu Lempinen
 * @author Tuomas Miettinen
 *
 */
public class AxisPropertyComposite extends Composite {

    TrackedText name, units, min, max;
    Button tlabels, tmarks;
    
    public AxisPropertyComposite(Composite parent, ISessionContext context, WidgetSupport support, int style) {
    	super(parent, style);
    	init(parent, context, support, style, false);
    }

	public AxisPropertyComposite(Composite parent, ISessionContext context, WidgetSupport support, int style, boolean vertical) {
        super(parent, style);
        init(parent, context, support, style, vertical);
    }
	
	private void init(Composite parent, ISessionContext context, WidgetSupport support, int style, boolean vertical) {
        GridLayoutFactory.fillDefaults().margins(3, 3).numColumns(vertical ? 2 : 3).applyTo(this);
        
        // Label (units)
        Label label = new Label(this, SWT.NONE);
        label.setText("Label: ");
        GridDataFactory.fillDefaults().align(SWT.END, SWT.FILL).applyTo(label);
        
        units = new TrackedText(this, support, SWT.BORDER);
        units.setTextFactory(new StringPropertyFactory(Layer0.URIs.HasLabel, "")); // FIXME: Units 
        units.addModifyListener(new StringPropertyModifier(context, Layer0.URIs.HasLabel)); // FIXME: Units 
        units.setColorProvider(new JFreeChartPropertyColorProvider(units.getResourceManager()));
        GridDataFactory.fillDefaults().grab(true, false).span(vertical ? 1 : 2, 1).applyTo(units.getWidget());
        
        
        // Minimum and maximum values
        label = new Label(this, SWT.NONE);
        label.setText("Min:");
        GridDataFactory.fillDefaults().align(SWT.END, SWT.FILL).applyTo(label);
        Composite minmax = new Composite(this, SWT.NONE);
        GridDataFactory.fillDefaults().applyTo(minmax);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(minmax);
        min = new TrackedText(minmax, support, SWT.BORDER);
        min.setColorProvider(new JFreeChartPropertyColorProvider(min.getResourceManager()));
        min.setTextFactory(new DoublePropertyFactory(JFreeChartResource.URIs.Axis_min));
        min.addModifyListener(new DoublePropertyModifier(context, JFreeChartResource.URIs.Axis_min));
        min.setInputValidator(new DoubleValidator(true));
        GridDataFactory.fillDefaults().hint(55, SWT.DEFAULT).applyTo(min.getWidget());
        
        label = new Label(minmax, SWT.NONE);
        label.setText("Max:");
        max = new TrackedText(minmax, support, SWT.BORDER);
        max.setColorProvider(new JFreeChartPropertyColorProvider(max.getResourceManager()));
        max.setTextFactory(new DoublePropertyFactory(JFreeChartResource.URIs.Axis_max));
        max.addModifyListener(new DoublePropertyModifier(context, JFreeChartResource.URIs.Axis_max));
        max.setInputValidator(new DoubleValidator(true));
        GridDataFactory.fillDefaults().hint(55, SWT.DEFAULT).applyTo(max.getWidget());
        
        Composite hideComposite = null;
        if (!vertical) {
		    // Tick and label visibility
        	hideComposite = new Composite(this, SWT.NONE);
		    GridDataFactory.fillDefaults().span(1, 2).applyTo(hideComposite);
		}
	    
        // Color
        label = new Label(this, SWT.NONE);
        label.setText("Color:");
        GridDataFactory.fillDefaults().align(SWT.END, SWT.CENTER).applyTo(label);
        
        Composite colorPicker = new ColorPicker(this, context, support, SWT.NONE);
        GridDataFactory.fillDefaults().grab(true, false).applyTo(colorPicker);
        
        if (vertical) {
		    // Tick and label visibility
        	hideComposite = new Composite(this, SWT.NONE);
		    GridDataFactory.fillDefaults().span(2, 1).applyTo(hideComposite);
		}
        
        // Fill hideComposite
        GridLayoutFactory.fillDefaults().applyTo(hideComposite);
	    Composite axisHide = new AxisHidePropertyComposite(hideComposite, context, support, SWT.NONE);
	    GridDataFactory.fillDefaults().applyTo(axisHide);
    
	}
    
}
