/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.jfreechart.chart.properties;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import org.eclipse.jface.fieldassist.ContentProposal;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.swt.widgets.Control;
import org.simantics.Simantics;
import org.simantics.browsing.ui.swt.widgets.impl.Widget;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.db.procedure.Listener;
import org.simantics.utils.ui.AdaptionUtils;

/**
 * 
 * @author Marko Luukkainen <marko.luukkainen@vtt.fi>
 *
 */
public class VariableProposalProvider implements IContentProposalProvider, Widget {

	/*
	 * The proposals provided.
	 */
	private Collection<ChartVariable> proposals;

	/*
	 * The proposals mapped to IContentProposal. Cached for speed in the case
	 * where filtering is not used.
	 */
	private IContentProposal[] contentProposals;

	/*
	 * Boolean that tracks whether filtering is used.
	 */
	private boolean filterProposals = false;


	private boolean compareRVI = false;
	/**
	 * Return an array of Objects representing the valid content proposals for a
	 * field. 
	 * 
	 * @param contents
	 *            the current contents of the field (only consulted if filtering
	 *            is set to <code>true</code>)
	 * @param position
	 *            the current cursor position within the field (ignored)
	 * @return the array of Objects that represent valid proposals for the field
	 *         given its current content.
	 */
	@SuppressWarnings("unchecked")
	public IContentProposal[] getProposals(String contents, int position) {
		if (filterProposals) {
			@SuppressWarnings("rawtypes")
            ArrayList list = new ArrayList();
			if (compareRVI) {
				for (ChartVariable proposal : proposals) {
					if (proposal.getRvi().length() >= contents.length() && proposal.getRvi().substring(0, contents.length()).equalsIgnoreCase(contents)) {
						if (proposal.getLabel() != null)
							list.add(new ContentProposal(proposal.getRvi(),proposal.getLabel(), null));
						else
							list.add(new ContentProposal(proposal.getRvi()));
					} else if (proposal.getLabel() != null && proposal.getLabel().length() >= contents.length() && proposal.getLabel().substring(0, contents.length()).equalsIgnoreCase(contents)) {
						list.add(new ContentProposal(proposal.getRvi(),proposal.getLabel(), null));
					}
				}
			} else {
				for (ChartVariable proposal : proposals) {
					if (proposal.getLabel() != null && proposal.getLabel().length() >= contents.length() && proposal.getLabel().substring(0, contents.length()).equalsIgnoreCase(contents)) {
						list.add(new ContentProposal(proposal.getRvi(),proposal.getLabel(), null));
					}
				}
			}
			
			return (IContentProposal[]) list.toArray(new IContentProposal[list
					.size()]);
		}
		if (contentProposals == null) {
			contentProposals = new IContentProposal[proposals.size()];
			Iterator<ChartVariable> iter = proposals.iterator();
			for (int i = 0; i < proposals.size(); i++) {
				ChartVariable proposal = iter.next();
				if (proposal.getLabel() != null)
					contentProposals[i] = new ContentProposal(proposal.getRvi(),proposal.getLabel(),null);
				else
					contentProposals[i] = new ContentProposal(proposal.getRvi());
			}
		}
		return contentProposals;
	}

	/**
	 * Set the Strings to be used as content proposals.
	 * 
	 * @param items
	 *            the array of Strings to be used as proposals.
	 */
	public void setProposals(Collection<ChartVariable> items) {
		this.proposals = items;
		contentProposals = null;
	}

	/**
	 * Set the boolean that controls whether proposals are filtered according to
	 * the current field content.
	 * 
	 * @param filterProposals
	 *            <code>true</code> if the proposals should be filtered to
	 *            show only those that match the current contents of the field,
	 *            and <code>false</code> if the proposals should remain the
	 *            same, ignoring the field content.
	 * @since 3.3
	 */
	public void setFiltering(boolean filterProposals) {
		this.filterProposals = filterProposals;
		// Clear any cached proposals.
		contentProposals = null;
	}
	
    /**
     * Provides all variables a model contains. Given resource needs to be
     * part of a model (i.e. using PartOf leads eventually to a SysdynModel).
     *  
     * @param control Control that is using this provider
     * @param resource A resource that is part of a model
     */
    public VariableProposalProvider(final Control control, WidgetSupport support) {
        this.proposals = new ArrayList<ChartVariable>();
        support.register(this);
        this.control = control;
    }

    private Resource resource;
    private Control control;
    
    @Override
    public void setInput(ISessionContext context, Object input) {

        final Resource resource = AdaptionUtils.adaptToSingle(input, Resource.class);
        if(resource == null)
            return;
        this.resource = resource;
        /* Find the model resource. It can be found with PartOf 
        relations from series resource in a chart */
       try {
		AllVariablesOfModel query = AllVariablesOfModel.withRandomResource(context, resource);
		 Simantics.getSession().asyncRequest(query
	        , new Listener<Collection<ChartVariable>>() {

	            @Override
	            public void execute(Collection<ChartVariable> result) {
	                setProposals(result);
	            }

	            @Override
	            public void exception(Throwable t) {
	                t.printStackTrace();
	            }

	            @Override
	            public boolean isDisposed() {
	                return control == null || 
	                        control.isDisposed() || 
	                        !resource.equals(VariableProposalProvider.this.resource);
	            }

	        }); 
	} catch (DatabaseException e) {
		// TODO Auto-generated catch block
		e.printStackTrace();
	}
        
       
        
    }
    
}
