package org.simantics.jfreechart.chart.properties;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Text;
import org.simantics.browsing.ui.swt.widgets.impl.Widget;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.management.ISessionContext;
import org.simantics.utils.ReflectionUtils;
import org.simantics.utils.ui.ISelectionUtils;

public abstract class StringChooserModifyListenerImpl<T,T2> implements StringChooserModifyListener<T2>, Widget {
	protected ISessionContext context;
	protected T lastInput = null;

	protected final Class<?> clazz;

	public StringChooserModifyListenerImpl() {
		clazz = ReflectionUtils.getSingleParameterType(getClass());
	}

	private Object getInputContents(Object input, Class<?> inputClass) {
		if (inputClass.isInstance(input))
			return input;
		if (input instanceof ISelection)
			return ISelectionUtils.filterSingleSelection(input, inputClass);
		return null;
	}

	@Override
	public void modifySelection(StringChooserModifyEvent<T2> e) {

		Text text = (Text)e.getWidget();
		final T2 object = e.getObject();
		final String textValue = text.getText();
		final T input = lastInput;

		try {
			context.getSession().syncRequest(new WriteRequest() {

				@SuppressWarnings("unchecked")
				@Override
				public void perform(WriteGraph graph) throws DatabaseException {
					
					if(clazz.isInstance(input)) {
						applyObject(graph, (T)input, object, textValue);
					} else {
						T single = (T)getInputContents(input, clazz);
						if(single != null)
							applyObject(graph, single, object, textValue);
					}

					
				}
				
			});
		} catch (DatabaseException e1) {
			e1.printStackTrace();
		}
	}

	@SuppressWarnings("unchecked")
	@Override
	public void setInput(ISessionContext context, Object parameter) {
		this.context = context;
		lastInput = (T)parameter;
	}

	abstract public void applyObject(WriteGraph graph, T input, T2 object, String text) throws DatabaseException;

}
