/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.jfreechart.chart.properties;

import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalListener;
import org.eclipse.jface.fieldassist.IContentProposalListener2;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.swt.widgets.Control;
import org.simantics.browsing.ui.swt.widgets.impl.TextModifyListenerImpl;
import org.simantics.browsing.ui.swt.widgets.impl.TrackedModifyEvent;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.databoard.Bindings;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.sysdyn.JFreeChartResource;

/**
 * Class for modifying variable name to rvi and saving it to database.
 * 
 * Modifier also adds content proposal support to the control it is added to.
 * @author Teemu Lempinen
 *
 */
public class RVIModifier extends TextModifyListenerImpl<Resource> {

    private boolean active;
    private Control control;
    private String rviUri;
    private String indexUri;
    
    private char[] alphaNumericCharacters = {
        'a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t','u','v','w','x','y','z','','','',
        'A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z','','','',
        '1','2','3','4','5','6','7','8','9','0','.'};
    
    /**
     * Create a new RVIModifier and attach a content proposal support to control
     * @param control
     * @param support
     */
    public RVIModifier(Control control, WidgetSupport support) {
        this(control, support, JFreeChartResource.URIs.variableRVI, JFreeChartResource.URIs.variableFilter);
    }
        
        
    public RVIModifier(Control control, WidgetSupport support, String rviRelationUri, String indexUri) {
        this.rviUri = rviRelationUri;
        this.indexUri = indexUri;
        
        this.control = control;
        this.active = true;
        
        KeyStroke keyStroke = null;
        try {
            keyStroke = KeyStroke.getInstance("Ctrl+Space");
        } catch (ParseException e1) {
            e1.printStackTrace();
        }
        
        //SimpleContentProposalProvider scpp = new VariableProposalProvider(control, support);
        VariableProposalProvider scpp = new VariableProposalProvider(control, support);
        scpp.setFiltering(true);

        ContentProposalAdapter adapter = new ContentProposalAdapter(
                control, new TextContentAdapter(), scpp, keyStroke, alphaNumericCharacters);
        adapter.setAutoActivationDelay(0);
        adapter.setProposalAcceptanceStyle(ContentProposalAdapter.PROPOSAL_REPLACE);
        adapter.addContentProposalListener(new IContentProposalListener2() {

            @Override
            public void proposalPopupOpened(ContentProposalAdapter adapter) {
                if(RVIModifier.this != null)
                    RVIModifier.this.deactivate();
            }

            @Override
            public void proposalPopupClosed(ContentProposalAdapter adapter) {
                if(RVIModifier.this != null)
                    RVIModifier.this.activate();
            }
        });

        adapter.addContentProposalListener(new IContentProposalListener() {

            @Override
            public void proposalAccepted(IContentProposal proposal) {
                if(RVIModifier.this.control != null && !RVIModifier.this.control.isDisposed())
                    RVIModifier.this.modifyText(new TrackedModifyEvent(RVIModifier.this.control, proposal.getContent()));
            }
        });
    
    
    }
    

    @Override
    public void applyText(WriteGraph graph, Resource resource, String text) throws DatabaseException {
        if(active) {
            text = "/" + text.replace('.', '/');
            graph.claimLiteral(resource, getRVIRelation(graph), text, Bindings.STRING);
            graph.deny(resource, getIndexRelation(graph));
        }
    }
    
    private Resource getRVIRelation(ReadGraph graph) throws DatabaseException {
        return graph.getResource(rviUri);
    }
    
    private Resource getIndexRelation(ReadGraph graph) throws DatabaseException {
        return graph.getResource(indexUri);
    }

    public void deactivate() {
        active = false;
    }

    public void activate() {
        active = true;
    }
}
