/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.jfreechart.chart.properties;

import org.eclipse.jface.dialogs.IInputValidator;

/**
 * Validator for validating that an input is double.
 * 
 * Can allow empty strings.
 * 
 * @author Teemu Lempinen
 *
 */
public class DoubleValidator implements IInputValidator {
    
    boolean allowEmpty;
    
    /**
     * New double validator. Does not allow empty strings
     */
    public DoubleValidator() {
        this(false);
    }
    
    /**
     * New double validator.
     * @param allowEmpty Are empty strings allowed
     */
    public DoubleValidator(boolean allowEmpty) {
        this.allowEmpty = allowEmpty;
    }
    
    @Override
    public String isValid(String newText) {
        if (allowEmpty && newText.trim().isEmpty())
            return null;
        try {
            Double.parseDouble(newText);
            return null;
        } catch (NumberFormatException e) {
            return e.getMessage();
        }
    }
}
