package org.simantics.jfreechart.chart.properties;

import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalListener;
import org.eclipse.jface.fieldassist.IContentProposalListener2;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.swt.widgets.Control;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.databoard.Bindings;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.sysdyn.JFreeChartResource;

public class ChartVariableModifier extends StringChooserModifyListenerImpl<Resource, ChartVariable> {
	
	 private boolean active;
	 private Control control;
	 
	 private char[] alphaNumericCharacters = {
		        'a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t','u','v','w','x','y','z','','','',
		        'A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z','','','',
		        '1','2','3','4','5','6','7','8','9','0','.','_'};
	 
	 public ChartVariableModifier(Control control, WidgetSupport support) {
	        this.control = control;
	        this.active = true;
	        
	        KeyStroke keyStroke = null;
	        try {
	            keyStroke = KeyStroke.getInstance("Ctrl+Space");
	        } catch (ParseException e1) {
	            e1.printStackTrace();
	        }
	        
	        //SimpleContentProposalProvider scpp = new VariableProposalProvider(control, support);
	        VariableProposalProvider scpp = new VariableProposalProvider(control, support);
	        scpp.setFiltering(true);

	        ContentProposalAdapter adapter = new ContentProposalAdapter(
	                control, new TextContentAdapter(), scpp, keyStroke, alphaNumericCharacters);
	        adapter.setAutoActivationDelay(0);
	        adapter.setProposalAcceptanceStyle(ContentProposalAdapter.PROPOSAL_REPLACE);
	        adapter.addContentProposalListener(new IContentProposalListener2() {

	            @Override
	            public void proposalPopupOpened(ContentProposalAdapter adapter) {
	                if(ChartVariableModifier.this != null)
	                	ChartVariableModifier.this.deactivate();
	            }

	            @Override
	            public void proposalPopupClosed(ContentProposalAdapter adapter) {
	                if(ChartVariableModifier.this != null)
	                	ChartVariableModifier.this.activate();
	            }
	        });

	        adapter.addContentProposalListener(new IContentProposalListener() {

	        	
	            @Override
	            public void proposalAccepted(IContentProposal proposal) {
	                if(ChartVariableModifier.this.control != null && !ChartVariableModifier.this.control.isDisposed())
	                	ChartVariableModifier.this.modifySelection(new StringChooserModifyEvent<ChartVariable>(ChartVariableModifier.this.control, new ChartVariable(proposal.getContent(), proposal.getLabel()), proposal.getLabel()));
	            }
	        });
	    
	    
	    }
	 
	 @Override
	public void applyObject(WriteGraph graph, Resource resource, ChartVariable object, String text) throws DatabaseException {
		    if(active) {
	            JFreeChartResource jfree = JFreeChartResource.getInstance(graph);
	            graph.claimLiteral(resource, jfree.variableRVI, object.getRvi(), Bindings.STRING);
	            graph.deny(resource, jfree.variableFilter);
	        }
		
	}
	    


    public void deactivate() {
        active = false;
    }

    public void activate() {
        active = true;
    }	 

}
