/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.jfreechart.chart.properties;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.simantics.browsing.ui.swt.widgets.Button;
import org.simantics.browsing.ui.swt.widgets.impl.WidgetSupport;
import org.simantics.db.management.ISessionContext;
import org.simantics.sysdyn.JFreeChartResource;

/**
 * Class containing properties for hiding pars of an axis
 * 
 * @author Teemu Lempinen
 *
 */
public class AxisHidePropertyComposite extends Composite {

    public AxisHidePropertyComposite(Composite parent, ISessionContext context, WidgetSupport support, int style) {
        super(parent, style);
        
        GridLayoutFactory.fillDefaults().applyTo(this);
        
        Group hideGroup  = new Group(this, SWT.NONE);
        hideGroup.setText("Hide");
        GridDataFactory.fillDefaults().applyTo(hideGroup);
        GridLayoutFactory.fillDefaults().margins(3, 3).numColumns(2).applyTo(hideGroup);
        
        Button label = new Button(hideGroup, support, SWT.CHECK);
        label.setText("Label");
        label.setSelectionFactory(new BooleanPropertyFactory(null, JFreeChartResource.URIs.Axis_visibleLabel, true));
        label.addSelectionListener(new BooleanSelectionListener(context, JFreeChartResource.URIs.Axis_visibleLabel));
        GridDataFactory.fillDefaults().applyTo(label.getWidget());

        Button tmarks = new Button(hideGroup, support, SWT.CHECK);
        tmarks.setText("Tick marks");
        tmarks.setSelectionFactory(new BooleanPropertyFactory(null, JFreeChartResource.URIs.Axis_visibleTickMarks, true));
        tmarks.addSelectionListener(new BooleanSelectionListener(context, JFreeChartResource.URIs.Axis_visibleTickMarks));
        GridDataFactory.fillDefaults().applyTo(tmarks.getWidget());
        
        Button axisLine = new Button(hideGroup, support, SWT.CHECK);
        axisLine.setText("Axis line");
        axisLine.setSelectionFactory(new BooleanPropertyFactory(null, JFreeChartResource.URIs.Axis_visibleAxisLine, true));
        axisLine.addSelectionListener(new BooleanSelectionListener(context, JFreeChartResource.URIs.Axis_visibleAxisLine));
        GridDataFactory.fillDefaults().applyTo(axisLine.getWidget());

        Button tlabels = new Button(hideGroup, support, SWT.CHECK);
        tlabels.setText("Tick labels");
        tlabels.setSelectionFactory(new BooleanPropertyFactory(null, JFreeChartResource.URIs.Axis_visibleTickLabels, true));
        tlabels.addSelectionListener(new BooleanSelectionListener(context, JFreeChartResource.URIs.Axis_visibleTickLabels));
        GridDataFactory.fillDefaults().applyTo(tlabels.getWidget());
    }

}
